/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.beans;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.beans.Bean;
import com.ifountain.opsgenie.client.model.beans.DAY;
import com.ifountain.opsgenie.client.model.beans.TimeRestrictionType;

public class Restriction
extends Bean {
    private Integer endHour;
    @JsonProperty(value="endMin")
    private Integer endMinute;
    private Integer startHour;
    @JsonProperty(value="startMin")
    private Integer startMinute;
    private DAY startDay;
    private DAY endDay;

    public void validateRestriction(TimeRestrictionType restrictionType) throws OpsGenieClientValidationException {
        if (this.endHour == null || this.endMinute == null || this.startHour == null || this.startMinute == null) {
            throw OpsGenieClientValidationException.error("startHour, startMinute, endHour, endMinute cannot be empty");
        }
        if (restrictionType.equals((Object)TimeRestrictionType.WEEKDAY_AND_TIME_OF_DAY) && (this.endDay == null || this.startDay == null)) {
            throw OpsGenieClientValidationException.error("startDay, endDay cannot be empty");
        }
        if (this.startHour > 24) {
            throw OpsGenieClientValidationException.invalidValues("startHour");
        }
        if (this.endHour > 24) {
            throw OpsGenieClientValidationException.invalidValues("endHour");
        }
    }

    public Integer getEndHour() {
        return this.endHour;
    }

    public void setEndHour(Integer endHour) {
        this.endHour = endHour;
    }

    public Integer getEndMinute() {
        return this.endMinute;
    }

    public void setEndMinute(Integer endMinute) {
        this.endMinute = endMinute;
    }

    public Integer getStartHour() {
        return this.startHour;
    }

    public void setStartHour(Integer startHour) {
        this.startHour = startHour;
    }

    public Integer getStartMinute() {
        return this.startMinute;
    }

    public void setStartMinute(Integer startMinute) {
        this.startMinute = startMinute;
    }

    public DAY getStartDay() {
        return this.startDay;
    }

    public void setStartDay(DAY startDay) {
        this.startDay = startDay;
    }

    public DAY getEndDay() {
        return this.endDay;
    }

    public void setEndDay(DAY endDay) {
        this.endDay = endDay;
    }

    public Restriction withEndHour(Integer endHour) {
        this.endHour = endHour;
        return this;
    }

    public Restriction withEndMinute(Integer endMinute) {
        this.endMinute = endMinute;
        return this;
    }

    public Restriction withStartHour(Integer startHour) {
        this.startHour = startHour;
        return this;
    }

    public Restriction withStartMinute(Integer startMinute) {
        this.startMinute = startMinute;
        return this;
    }

    public Restriction withStartDay(DAY startDay) {
        this.startDay = startDay;
        return this;
    }

    public Restriction withEndDay(DAY endDay) {
        this.endDay = endDay;
        return this;
    }
}

