/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.beans;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ifountain.opsgenie.client.model.ConvertFromTimeZone;
import com.ifountain.opsgenie.client.model.beans.BeanWithId;
import com.ifountain.opsgenie.client.model.beans.DataWithName;
import com.ifountain.opsgenie.client.model.beans.ScheduleRotation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;

public class Schedule
extends BeanWithId
implements ConvertFromTimeZone {
    private String name;
    private DataWithName ownerTeam;
    private String description;
    @JsonProperty(value="timezone")
    private TimeZone timeZone;
    private Boolean enabled;
    private List<ScheduleRotation> rotations;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public List<ScheduleRotation> getRotations() {
        return this.rotations;
    }

    public void setRotations(List<ScheduleRotation> rotations) {
        this.rotations = rotations;
    }

    public DataWithName getOwnerTeam() {
        return this.ownerTeam;
    }

    public void setOwnerTeam(DataWithName ownerTeam) {
        this.ownerTeam = ownerTeam;
    }

    @Override
    public void setTime() throws ParseException {
        if (this.getTimeZone() != null && this.rotations != null && !this.rotations.isEmpty()) {
            for (ScheduleRotation scheduleRotation : this.rotations) {
                scheduleRotation.setScheduleTimeZone(this.getTimeZone());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                sdf.setTimeZone(this.getTimeZone());
            }
        }
    }

    @Override
    public TimeZone getObjectTimeZone() {
        return this.timeZone;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Schedule withName(String name) {
        this.name = name;
        return this;
    }

    public Schedule withOwnerTeam(DataWithName team) {
        this.ownerTeam = team;
        return this;
    }

    public Schedule withDescription(String description) {
        this.description = description;
        return this;
    }

    public Schedule withTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public Schedule withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Schedule withRotations(List<ScheduleRotation> rotations) {
        this.rotations = rotations;
        return this;
    }
}

