/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.beans;

import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.beans.Bean;
import org.apache.commons.lang3.StringUtils;

public class ScheduleParticipant
extends Bean {
    private Type type;
    private String id;
    private String name;
    private String username;

    public void validateParticipant() throws OpsGenieClientValidationException {
        if (this.type == null) {
            throw OpsGenieClientValidationException.missingMandatoryProperty("participant type");
        }
        if (this.type.equals((Object)Type.team) || this.type.equals((Object)Type.escalation)) {
            if (StringUtils.isEmpty((CharSequence)this.id) && StringUtils.isEmpty((CharSequence)this.name)) {
                throw OpsGenieClientValidationException.error("For participant type team/escalation either team/escalation name or id must be provided.");
            }
        } else if (this.type != Type.none && StringUtils.isEmpty((CharSequence)this.id) && StringUtils.isEmpty((CharSequence)this.username)) {
            throw OpsGenieClientValidationException.error("Username or id must be provided.");
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public ScheduleParticipant withId(String id) {
        this.id = id;
        return this;
    }

    public ScheduleParticipant withUsername(String username) {
        this.username = username;
        return this;
    }

    public ScheduleParticipant withName(String name) {
        this.name = name;
        return this;
    }

    public ScheduleParticipant withType(Type type) {
        this.type = type;
        return this;
    }

    public static enum Type {
        user,
        group,
        escalation,
        schedule,
        team,
        none;

    }
}

