/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.beans;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.ObjectWithTimeZone;
import com.ifountain.opsgenie.client.model.beans.BeanWithId;
import com.ifountain.opsgenie.client.model.beans.ScheduleParticipant;
import com.ifountain.opsgenie.client.model.beans.TimeRestriction;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class ScheduleRotation
extends BeanWithId
implements ObjectWithTimeZone {
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date startDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date endDate;
    @JsonProperty(value="type")
    private RotationType rotationType;
    @JsonProperty(value="length")
    private Integer rotationLength = 1;
    private List<ScheduleParticipant> participants;
    private TimeRestriction timeRestriction;
    private TimeZone scheduleTimeZone;
    private String name;

    public void validateScheduleRotation() throws OpsGenieClientValidationException {
        if (this.rotationType == null) {
            throw OpsGenieClientValidationException.missingMandatoryProperty("rotationType");
        }
        this.validateStartAndEndDate();
        this.validateParticipants();
        if (this.timeRestriction != null) {
            this.timeRestriction.validateTimeRestriction();
        }
    }

    public void validateStartAndEndDate() throws OpsGenieClientValidationException {
        if (this.startDate == null) {
            throw OpsGenieClientValidationException.missingMandatoryProperty("startDate");
        }
        if (this.endDate != null && this.startDate.after(this.endDate)) {
            throw OpsGenieClientValidationException.error("Rotation end time should be later than start time.");
        }
    }

    public void validateParticipants() throws OpsGenieClientValidationException {
        if (this.participants == null || this.participants.isEmpty()) {
            throw OpsGenieClientValidationException.missingMandatoryProperty("participants");
        }
        for (ScheduleParticipant participant : this.participants) {
            participant.validateParticipant();
        }
    }

    public TimeRestriction getTimeRestriction() {
        return this.timeRestriction;
    }

    public void setTimeRestriction(TimeRestriction timeRestriction) {
        this.timeRestriction = timeRestriction;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public RotationType getRotationType() {
        return this.rotationType;
    }

    public void setRotationType(RotationType rotationType) {
        this.rotationType = rotationType;
    }

    public Integer getRotationLength() {
        return this.rotationLength;
    }

    public void setRotationLength(Integer rotationLength) {
        this.rotationLength = rotationLength;
    }

    public List<ScheduleParticipant> getParticipants() {
        return this.participants;
    }

    public void setParticipants(List<ScheduleParticipant> participants) {
        this.participants = participants;
    }

    public TimeZone getScheduleTimeZone() {
        return this.scheduleTimeZone;
    }

    public void setScheduleTimeZone(TimeZone scheduleTimeZone) {
        this.scheduleTimeZone = scheduleTimeZone;
    }

    @Override
    public TimeZone getObjectTimeZone() {
        return this.scheduleTimeZone;
    }

    public ScheduleRotation withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    public ScheduleRotation withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public ScheduleRotation withRotationType(RotationType rotationType) {
        this.rotationType = rotationType;
        return this;
    }

    public ScheduleRotation withRotationLength(Integer rotationLength) {
        this.rotationLength = rotationLength;
        return this;
    }

    public ScheduleRotation withParticipants(List<ScheduleParticipant> participants) {
        this.participants = participants;
        return this;
    }

    public ScheduleRotation withScheduleTimeZone(TimeZone scheduleTimeZone) {
        this.scheduleTimeZone = scheduleTimeZone;
        return this;
    }

    public ScheduleRotation withName(String name) {
        this.name = name;
        return this;
    }

    public ScheduleRotation withTimeRestriction(TimeRestriction timeRestriction) {
        this.timeRestriction = timeRestriction;
        return this;
    }

    public static enum RotationType {
        weekly,
        daily,
        hourly;

    }
}

