/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.beans;

import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.beans.Bean;
import com.ifountain.opsgenie.client.model.beans.Restriction;
import com.ifountain.opsgenie.client.model.beans.TimeRestrictionType;
import java.util.List;

public class TimeRestriction
extends Bean {
    private String type;
    private List<Restriction> restrictions;

    public void validateTimeRestriction() throws OpsGenieClientValidationException {
        if (TimeRestrictionType.getFromValues(this.type) == null) {
            throw OpsGenieClientValidationException.invalidValues("timeRestrictionType");
        }
        if (TimeRestrictionType.WEEKDAY_AND_TIME_OF_DAY.getValue().equalsIgnoreCase(this.type)) {
            this.validateRestrictions(TimeRestrictionType.WEEKDAY_AND_TIME_OF_DAY);
        } else if (TimeRestrictionType.TIME_OF_DAY.getValue().equalsIgnoreCase(this.type)) {
            this.validateRestrictions(TimeRestrictionType.TIME_OF_DAY);
        }
    }

    public void validateRestrictions(TimeRestrictionType timeRestrictionType) throws OpsGenieClientValidationException {
        if (this.restrictions == null || this.restrictions.isEmpty()) {
            throw OpsGenieClientValidationException.missingMandatoryProperty("restrictions");
        }
        for (Restriction restriction : this.restrictions) {
            restriction.validateRestriction(timeRestrictionType);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<Restriction> getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(List<Restriction> restrictions) {
        this.restrictions = restrictions;
    }
}

