/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.beans;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ifountain.opsgenie.client.model.beans.BaseUserObj;
import com.ifountain.opsgenie.client.model.beans.Contact;
import com.ifountain.opsgenie.client.model.beans.UserAddress;
import com.ifountain.opsgenie.client.model.beans.UserRole;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class User
extends BaseUserObj {
    private static final Map<String, Locale> LOCALES = new HashMap<String, Locale>();
    private Boolean blocked;
    private Boolean verified;
    private String fullName;
    private UserRole role;
    private String skypeUsername;
    private TimeZone timeZone;
    private Locale locale;
    private List<String> tags;
    private UserAddress userAddress;
    private Map<String, List<String>> details;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date createdAt;
    @JsonProperty(value="userContacts")
    private List<Contact> contacts;

    public List<Contact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<Contact> contacts) {
        this.contacts = contacts;
    }

    public Boolean getBlocked() {
        return this.blocked;
    }

    public void setBlocked(Boolean blocked) {
        this.blocked = blocked;
    }

    public Boolean getVerified() {
        return this.verified;
    }

    public void setVerified(Boolean verified) {
        this.verified = verified;
    }

    public UserRole getRole() {
        return this.role;
    }

    public void setRole(UserRole role) {
        this.role = role;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public UserAddress getUserAddress() {
        return this.userAddress;
    }

    public void setUserAddress(UserAddress userAddress) {
        this.userAddress = userAddress;
    }

    public Map<String, List<String>> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, List<String>> details) {
        this.details = details;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public static String getLocaleId(Locale locale) {
        return locale.toString();
    }

    public static Locale getLocale(String localeId) {
        return LOCALES.get(localeId);
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getSkypeUsername() {
        return this.skypeUsername;
    }

    public void setSkypeUsername(String skypeUsername) {
        this.skypeUsername = skypeUsername;
    }

    public User withFullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    public User withSkypeUsername(String skypeUsername) {
        this.skypeUsername = skypeUsername;
        return this;
    }

    public User withTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public User withLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public User withRole(UserRole role) {
        this.role = role;
        return this;
    }

    public User withContacts(List<Contact> contacts) {
        this.contacts = contacts;
        return this;
    }

    public User withBlocked(Boolean blocked) {
        this.blocked = blocked;
        return this;
    }

    public User withVerified(Boolean verified) {
        this.verified = verified;
        return this;
    }

    public User withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public User withDetails(Map<String, List<String>> details) {
        this.details = details;
        return this;
    }

    public User withUserAddress(UserAddress userAddress) {
        this.userAddress = userAddress;
        return this;
    }

    static {
        for (Locale locale : Locale.getAvailableLocales()) {
            LOCALES.put(User.getLocaleId(locale), locale);
        }
    }
}

