/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.schedule;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.BaseRequest;
import com.ifountain.opsgenie.client.model.ObjectWithTimeZone;
import com.ifountain.opsgenie.client.model.beans.DataWithName;
import com.ifountain.opsgenie.client.model.beans.ScheduleRotation;
import com.ifountain.opsgenie.client.model.schedule.AddScheduleResponse;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class AddScheduleRequest
extends BaseRequest<AddScheduleResponse, AddScheduleRequest>
implements ObjectWithTimeZone {
    private String name;
    private Boolean enabled;
    @JsonProperty(value="timezone")
    private TimeZone timeZone;
    private List<ScheduleRotation> rotations;
    private DataWithName ownerTeam;
    private String description;

    @Override
    public String getEndPoint() {
        return "/v2/schedules";
    }

    @Override
    public void validate() throws OpsGenieClientValidationException {
        super.validate();
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            throw OpsGenieClientValidationException.missingMandatoryProperty("name");
        }
        this.validateRotations(this.rotations);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ScheduleRotation> getRotations() {
        if (this.getTimeZone() != null && this.rotations != null) {
            for (ScheduleRotation scheduleRotation : this.rotations) {
                scheduleRotation.setScheduleTimeZone(this.getTimeZone());
            }
        }
        return this.rotations;
    }

    public void setRotations(List<ScheduleRotation> rotations) {
        this.rotations = rotations;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public AddScheduleResponse createResponse() {
        return new AddScheduleResponse();
    }

    public DataWithName getOwnerTeam() {
        return this.ownerTeam;
    }

    public void setOwnerTeam(DataWithName ownerTeam) {
        this.ownerTeam = ownerTeam;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public TimeZone getObjectTimeZone() {
        return this.timeZone;
    }

    public AddScheduleRequest withName(String name) {
        this.name = name;
        return this;
    }

    public AddScheduleRequest withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public AddScheduleRequest withTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public AddScheduleRequest withRotations(List<ScheduleRotation> rotations) {
        this.rotations = rotations;
        return this;
    }

    public AddScheduleRequest withTeam(DataWithName team) {
        this.ownerTeam = team;
        return this;
    }

    public AddScheduleRequest withDescription(String description) {
        this.description = description;
        return this;
    }
}

