/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.schedule;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.BaseRequest;
import com.ifountain.opsgenie.client.model.ObjectWithTimeZone;
import com.ifountain.opsgenie.client.model.beans.DataWithName;
import com.ifountain.opsgenie.client.model.beans.IdentifierType;
import com.ifountain.opsgenie.client.model.beans.ScheduleRotation;
import com.ifountain.opsgenie.client.model.schedule.AddScheduleRequest;
import com.ifountain.opsgenie.client.model.schedule.AddScheduleResponse;
import com.ifountain.opsgenie.client.model.schedule.UpdateScheduleResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class UpdateScheduleRequest
extends BaseRequest<AddScheduleResponse, AddScheduleRequest>
implements ObjectWithTimeZone {
    @JsonIgnore
    private String identifier;
    @JsonIgnore
    private String identifierType;
    private String name;
    private Boolean enabled;
    @JsonProperty(value="timezone")
    private TimeZone timeZone;
    private List<ScheduleRotation> rotations;
    @JsonProperty(value="ownerTeam")
    private DataWithName team;
    private String description;

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifierType() {
        return this.identifierType;
    }

    public void setIdentifierType(String identifierType) {
        this.identifierType = identifierType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ScheduleRotation> getRotations() {
        if (this.getTimeZone() != null && this.rotations != null) {
            for (ScheduleRotation scheduleRotation : this.rotations) {
                scheduleRotation.setScheduleTimeZone(this.getTimeZone());
            }
        }
        return this.rotations;
    }

    public void setRotations(List<ScheduleRotation> rotations) {
        this.rotations = rotations;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public DataWithName getTeam() {
        return this.team;
    }

    public void setTeam(DataWithName team) {
        this.team = team;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public TimeZone getObjectTimeZone() {
        return this.timeZone;
    }

    public UpdateScheduleRequest withIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public UpdateScheduleRequest withIdentifierType(String identifierType) {
        this.identifierType = identifierType;
        return this;
    }

    public UpdateScheduleRequest withName(String name) {
        this.name = name;
        return this;
    }

    public UpdateScheduleRequest withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public UpdateScheduleRequest withTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public UpdateScheduleRequest withRotations(List<ScheduleRotation> rotations) {
        this.rotations = rotations;
        return this;
    }

    public UpdateScheduleRequest withTeam(DataWithName team) {
        this.team = team;
        return this;
    }

    public UpdateScheduleRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public String getEndPoint() {
        return "/v2/schedules/" + this.identifier;
    }

    @Override
    public void validate() throws OpsGenieClientValidationException {
        super.validate();
        if (StringUtils.isNotEmpty((CharSequence)this.identifierType) && Objects.isNull((Object)IdentifierType.getFromValues(this.identifierType))) {
            throw OpsGenieClientValidationException.invalidValues("identifierType");
        }
        if (StringUtils.isEmpty((CharSequence)this.identifier)) {
            throw OpsGenieClientValidationException.missingMultipleMandatoryProperty("name", "id");
        }
        this.validateRotations(this.rotations);
    }

    @Override
    public Map<String, Object> getRequestParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)this.identifierType)) {
            params.put("identifierType", this.identifierType);
        } else {
            params.put("identifierType", "id");
        }
        return params;
    }

    @Override
    public UpdateScheduleResponse createResponse() {
        return new UpdateScheduleResponse();
    }
}

