/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.team;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.BaseRequest;
import com.ifountain.opsgenie.client.model.beans.BaseUserObj;
import com.ifountain.opsgenie.client.model.beans.IdentifierType;
import com.ifountain.opsgenie.client.model.beans.Role;
import com.ifountain.opsgenie.client.model.team.AddTeamMemberResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class AddTeamMemberRequest
extends BaseRequest<AddTeamMemberResponse, AddTeamMemberRequest> {
    @JsonIgnore
    private String teamIdentifier;
    @JsonIgnore
    private String teamIdentifierType;
    private BaseUserObj user;
    private Role role;

    @Override
    public String getEndPoint() {
        return "/v2/teams/" + this.teamIdentifier + "/members";
    }

    @Override
    public void validate() throws OpsGenieClientValidationException {
        super.validate();
        if (StringUtils.isNotEmpty((CharSequence)this.teamIdentifierType) && Objects.isNull((Object)IdentifierType.getFromValues(this.teamIdentifierType))) {
            throw OpsGenieClientValidationException.invalidValues("teamIdentifierType");
        }
        if (StringUtils.isEmpty((CharSequence)this.teamIdentifier)) {
            throw OpsGenieClientValidationException.missingMultipleMandatoryProperty("name", "id");
        }
        if (this.user == null) {
            throw OpsGenieClientValidationException.missingMandatoryProperty("user");
        }
        if (StringUtils.isEmpty((CharSequence)this.user.getUsername()) && StringUtils.isEmpty((CharSequence)this.user.getId())) {
            throw OpsGenieClientValidationException.error("Either id or username should be present in user field");
        }
    }

    @Override
    public Map<String, Object> getRequestParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)this.teamIdentifierType)) {
            params.put("teamIdentifierType", this.teamIdentifierType);
        } else {
            params.put("teamIdentifierType", "id");
        }
        return params;
    }

    public String getTeamIdentifier() {
        return this.teamIdentifier;
    }

    public void setTeamIdentifier(String teamIdentifier) {
        this.teamIdentifier = teamIdentifier;
    }

    public String getTeamIdentifierType() {
        return this.teamIdentifierType;
    }

    public void setTeamIdentifierType(String teamIdentifierType) {
        this.teamIdentifierType = teamIdentifierType;
    }

    public BaseUserObj getUser() {
        return this.user;
    }

    public void setUser(BaseUserObj user) {
        this.user = user;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    @Override
    public AddTeamMemberResponse createResponse() {
        return new AddTeamMemberResponse();
    }

    public AddTeamMemberRequest withTeamIdentifier(String teamIdentifier) {
        this.teamIdentifier = teamIdentifier;
        return this;
    }

    public AddTeamMemberRequest withTeamIdentifierType(String teamIdentifierType) {
        this.teamIdentifierType = teamIdentifierType;
        return this;
    }

    public AddTeamMemberRequest withRole(Role role) {
        this.role = role;
        return this;
    }

    public AddTeamMemberRequest withUser(BaseUserObj user) {
        this.user = user;
        return this;
    }
}

