/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.team;

import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.BaseRequest;
import com.ifountain.opsgenie.client.model.beans.Links;
import com.ifountain.opsgenie.client.model.beans.Team;
import com.ifountain.opsgenie.client.model.team.AddTeamResponse;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class AddTeamRequest
extends BaseRequest<AddTeamResponse, AddTeamRequest> {
    private String name;
    private String description;
    private List<Team.TeamMember> members;
    private Links links;

    public Links getLinks() {
        return this.links;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    @Override
    public String getEndPoint() {
        return "/v2/teams";
    }

    @Override
    public void validate() throws OpsGenieClientValidationException {
        super.validate();
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            throw OpsGenieClientValidationException.missingMandatoryProperty("name");
        }
        if (Objects.nonNull(this.members)) {
            for (Team.TeamMember member : this.members) {
                if (member.getUser() == null) {
                    throw OpsGenieClientValidationException.error("User should be present in member field");
                }
                if (!StringUtils.isEmpty((CharSequence)member.getUser().getUsername()) || !StringUtils.isEmpty((CharSequence)member.getUser().getId())) continue;
                throw OpsGenieClientValidationException.error("Either username or id of user should be present");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Team.TeamMember> getMembers() {
        return this.members;
    }

    public void setMembers(List<Team.TeamMember> members) {
        this.members = members;
    }

    @Override
    public AddTeamResponse createResponse() {
        return new AddTeamResponse();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AddTeamRequest withName(String name) {
        this.name = name;
        return this;
    }

    public AddTeamRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public AddTeamRequest withMembers(List<Team.TeamMember> members) {
        this.members = members;
        return this;
    }
}

