/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.team;

import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.BaseRequest;
import com.ifountain.opsgenie.client.model.beans.IdentifierType;
import com.ifountain.opsgenie.client.model.team.DeleteTeamMemberResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DeleteTeamMemberRequest
extends BaseRequest<DeleteTeamMemberResponse, DeleteTeamMemberRequest> {
    private String teamIdentifier;
    private String memberIdentifier;
    private String teamIdentifierType;

    @Override
    public String getEndPoint() {
        return "/v2/teams/" + this.teamIdentifier + "/members/" + this.memberIdentifier;
    }

    @Override
    public Map<String, Object> getRequestParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)this.teamIdentifierType)) {
            params.put("teamIdentifierType", this.teamIdentifierType);
        } else {
            params.put("teamIdentifierType", "id");
        }
        return params;
    }

    @Override
    public void validate() throws OpsGenieClientValidationException {
        super.validate();
        if (StringUtils.isNotEmpty((CharSequence)this.teamIdentifierType) && Objects.isNull((Object)IdentifierType.getFromValues(this.teamIdentifierType))) {
            throw OpsGenieClientValidationException.invalidValues("teamIdentifierType");
        }
        if (StringUtils.isEmpty((CharSequence)this.teamIdentifier)) {
            throw OpsGenieClientValidationException.missingMultipleMandatoryProperty("name", "id");
        }
        if (StringUtils.isEmpty((CharSequence)this.memberIdentifier)) {
            throw OpsGenieClientValidationException.missingMultipleMandatoryProperty("username", "userId");
        }
    }

    @Override
    public DeleteTeamMemberResponse createResponse() {
        return new DeleteTeamMemberResponse();
    }

    public String getTeamIdentifier() {
        return this.teamIdentifier;
    }

    public void setTeamIdentifier(String teamIdentifier) {
        this.teamIdentifier = teamIdentifier;
    }

    public String getMemberIdentifier() {
        return this.memberIdentifier;
    }

    public void setMemberIdentifier(String memberIdentifier) {
        this.memberIdentifier = memberIdentifier;
    }

    public String getTeamIdentifierType() {
        return this.teamIdentifierType;
    }

    public void setTeamIdentifierType(String teamIdentifierType) {
        this.teamIdentifierType = teamIdentifierType;
    }

    public DeleteTeamMemberRequest withTeamIdentifier(String teamIdentifier) {
        this.teamIdentifier = teamIdentifier;
        return this;
    }

    public DeleteTeamMemberRequest withTeamIdentifierType(String teamIdentifierType) {
        this.teamIdentifierType = teamIdentifierType;
        return this;
    }

    public DeleteTeamMemberRequest withMemberIdentifier(String memberIdentifier) {
        this.memberIdentifier = memberIdentifier;
        return this;
    }
}

