/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.team;

import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.BaseRequest;
import com.ifountain.opsgenie.client.model.beans.IdentifierType;
import com.ifountain.opsgenie.client.model.team.DeleteTeamResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DeleteTeamRequest
extends BaseRequest<DeleteTeamResponse, DeleteTeamRequest> {
    private String identifier;
    private String identifierType;

    @Override
    public void validate() throws OpsGenieClientValidationException {
        super.validate();
        if (StringUtils.isNotEmpty((CharSequence)this.identifierType) && Objects.isNull((Object)IdentifierType.getFromValues(this.identifierType))) {
            throw OpsGenieClientValidationException.invalidValues("identifierType");
        }
        if (StringUtils.isEmpty((CharSequence)this.identifier)) {
            throw OpsGenieClientValidationException.missingMultipleMandatoryProperty("name", "id");
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifierType() {
        return this.identifierType;
    }

    public void setIdentifierType(String identifierType) {
        this.identifierType = identifierType;
    }

    @Override
    public String getEndPoint() {
        return "/v2/teams/" + this.identifier;
    }

    @Override
    public Map<String, Object> getRequestParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)this.identifierType)) {
            params.put("identifierType", this.identifierType);
        } else {
            params.put("identifierType", "id");
        }
        return params;
    }

    @Override
    public DeleteTeamResponse createResponse() {
        return new DeleteTeamResponse();
    }

    public DeleteTeamRequest withIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public DeleteTeamRequest withIdentifierType(String identifierType) {
        this.identifierType = identifierType;
        return this;
    }
}

