/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.team;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.BaseRequest;
import com.ifountain.opsgenie.client.model.beans.IdentifierType;
import com.ifountain.opsgenie.client.model.team.ListTeamLogsResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ListTeamLogsRequest
extends BaseRequest<ListTeamLogsResponse, ListTeamLogsRequest> {
    private String identifier;
    private String identifierType;
    @JsonProperty(value="order")
    private SortOrder sortOrder = SortOrder.asc;
    private Integer limit = 20;
    private String offset;

    @Override
    public void validate() throws OpsGenieClientValidationException {
        super.validate();
        if (StringUtils.isNotEmpty((CharSequence)this.identifierType) && Objects.isNull((Object)IdentifierType.getFromValues(this.identifierType))) {
            throw OpsGenieClientValidationException.invalidValues("identifierType");
        }
        if (StringUtils.isEmpty((CharSequence)this.identifier)) {
            throw OpsGenieClientValidationException.missingMultipleMandatoryProperty("name", "id");
        }
    }

    @Override
    public Map<String, Object> getRequestParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)this.identifierType)) {
            params.put("identifierType", this.identifierType);
        } else {
            params.put("identifierType", "id");
        }
        if (this.limit != null && this.limit >= 20 && this.limit <= 100) {
            params.put("limit", this.limit);
        }
        if (this.limit != null && this.limit > 100) {
            params.put("limit", 100);
        }
        if (this.limit != null && this.limit < 20) {
            params.put("limit", 20);
        }
        if (this.sortOrder != null) {
            params.put("order", (Object)this.sortOrder);
        }
        if (this.offset != null) {
            params.put("offset", this.offset);
        }
        return params;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public String getOffset() {
        return this.offset;
    }

    public void setOffset(String offset) {
        this.offset = offset;
    }

    @Override
    public String getEndPoint() {
        return "/v2/teams/" + this.identifier + "/logs";
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifierType() {
        return this.identifierType;
    }

    public void setIdentifierType(String identifierType) {
        this.identifierType = identifierType;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Override
    public ListTeamLogsResponse createResponse() {
        return new ListTeamLogsResponse();
    }

    public ListTeamLogsRequest withIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public ListTeamLogsRequest withIdentifierType(String identifierType) {
        this.identifierType = identifierType;
        return this;
    }

    public ListTeamLogsRequest withSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    public ListTeamLogsRequest withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public ListTeamLogsRequest withOffset(String offset) {
        this.offset = offset;
        return this;
    }

    public static enum SortOrder {
        asc,
        desc;

    }
}

