/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.BaseRequest;
import com.ifountain.opsgenie.client.model.beans.UserAddress;
import com.ifountain.opsgenie.client.model.beans.UserRole;
import com.ifountain.opsgenie.client.model.user.AddUserResponse;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class AddUserRequest
extends BaseRequest<AddUserResponse, AddUserRequest> {
    private String username;
    private String fullName;
    private UserRole role;
    private String skypeUsername;
    private UserAddress userAddress;
    private List<String> tags;
    private Map<String, List<String>> details;
    @JsonProperty(value="timezone")
    private TimeZone timeZone;
    private Locale locale;
    private Boolean invitationDisabled = false;

    @Override
    public String getEndPoint() {
        return "/v2/users";
    }

    @Override
    public void validate() throws OpsGenieClientValidationException {
        super.validate();
        if (StringUtils.isEmpty((CharSequence)this.username)) {
            throw OpsGenieClientValidationException.missingMandatoryProperty("username");
        }
        if (StringUtils.isEmpty((CharSequence)this.fullName)) {
            throw OpsGenieClientValidationException.missingMultipleMandatoryProperty("fullname");
        }
        if (this.role == null || StringUtils.isEmpty((CharSequence)this.role.getName())) {
            throw OpsGenieClientValidationException.missingMandatoryProperty("role");
        }
    }

    public void setRole(UserRole role) {
        this.role = role;
    }

    public UserAddress getUserAddress() {
        return this.userAddress;
    }

    public void setUserAddress(UserAddress userAddress) {
        this.userAddress = userAddress;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Map<String, List<String>> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, List<String>> details) {
        this.details = details;
    }

    public Boolean getInvitationDisabled() {
        return this.invitationDisabled;
    }

    public void setInvitationDisabled(Boolean invitationDisabled) {
        this.invitationDisabled = invitationDisabled;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @JsonProperty(value="role")
    public UserRole getUserRole() {
        return this.role;
    }

    public void setUserRole(UserRole role) {
        this.role = role;
    }

    @Override
    public AddUserResponse createResponse() {
        return new AddUserResponse();
    }

    public String getSkypeUsername() {
        return this.skypeUsername;
    }

    public void setSkypeUsername(String skypeUsername) {
        this.skypeUsername = skypeUsername;
    }

    public AddUserRequest withUsername(String username) {
        this.username = username;
        return this;
    }

    public AddUserRequest withUserAddress(UserAddress userAddress) {
        this.userAddress = userAddress;
        return this;
    }

    public AddUserRequest withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public AddUserRequest withDetails(Map<String, List<String>> details) {
        this.details = details;
        return this;
    }

    public AddUserRequest withInvitationDisabled(Boolean invitationDisabled) {
        this.invitationDisabled = invitationDisabled;
        return this;
    }

    public AddUserRequest withFullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    public AddUserRequest withSkypeUsername(String skypeUsername) {
        this.skypeUsername = skypeUsername;
        return this;
    }

    public AddUserRequest withTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public AddUserRequest withLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public AddUserRequest withRole(UserRole role) {
        this.role = role;
        return this;
    }
}

