/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.user;

import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.BaseRequest;
import com.ifountain.opsgenie.client.model.user.GetUserResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class GetUserRequest
extends BaseRequest<GetUserResponse, GetUserRequest> {
    private String identifier;
    private String expand;

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    @Override
    public void validate() throws OpsGenieClientValidationException {
        super.validate();
        if (StringUtils.isEmpty((CharSequence)this.identifier)) {
            throw OpsGenieClientValidationException.missingMultipleMandatoryProperty("username", "id");
        }
        if (StringUtils.isNotBlank((CharSequence)this.expand) && !this.expand.equalsIgnoreCase("contact")) {
            throw OpsGenieClientValidationException.invalidValues("expand");
        }
    }

    @Override
    public Map<String, Object> getRequestParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)this.expand)) {
            params.put("expand", this.expand);
        }
        return params;
    }

    @Override
    public String getEndPoint() {
        return "/v2/users/" + this.identifier;
    }

    @Override
    public GetUserResponse createResponse() {
        return new GetUserResponse();
    }

    public GetUserRequest withIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public GetUserRequest withExpand(String expand) {
        this.expand = expand;
        return this;
    }
}

