/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.user.forward;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.BaseRequest;
import com.ifountain.opsgenie.client.model.ObjectWithTimeZone;
import com.ifountain.opsgenie.client.model.beans.BaseUserObj;
import com.ifountain.opsgenie.client.model.user.forward.AddForwardingResponse;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class AddForwardingRequest
extends BaseRequest<AddForwardingResponse, AddForwardingRequest>
implements ObjectWithTimeZone {
    private String alias;
    private BaseUserObj fromUser;
    private BaseUserObj toUser;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date startDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date endDate;
    @JsonProperty(value="timezone")
    private TimeZone timeZone = TimeZone.getTimeZone("GMT");

    @Override
    public String getEndPoint() {
        return "/v2/forwarding-rules";
    }

    @Override
    public void validate() throws OpsGenieClientValidationException {
        super.validate();
        if (this.fromUser == null) {
            throw OpsGenieClientValidationException.missingMandatoryProperty("fromUser");
        }
        if (StringUtils.isEmpty((CharSequence)this.fromUser.getUsername()) && StringUtils.isEmpty((CharSequence)this.fromUser.getId())) {
            throw OpsGenieClientValidationException.error("Either username or id in from user is mandatory");
        }
        if (this.toUser == null) {
            throw OpsGenieClientValidationException.missingMandatoryProperty("toUser");
        }
        if (StringUtils.isEmpty((CharSequence)this.toUser.getUsername()) && StringUtils.isEmpty((CharSequence)this.toUser.getId())) {
            throw OpsGenieClientValidationException.error("Either username or id in to user is mandatory");
        }
        if (this.startDate == null || this.endDate == null) {
            throw OpsGenieClientValidationException.missingMultipleMandatoryProperty("startDate", "endDate");
        }
        if (this.startDate.before(Calendar.getInstance().getTime())) {
            throw OpsGenieClientValidationException.error("Start Time can not be before now.");
        }
        if (this.startDate.after(this.endDate)) {
            throw OpsGenieClientValidationException.error("End time should be later than start time.");
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public BaseUserObj getFromUser() {
        return this.fromUser;
    }

    public void setFromUser(BaseUserObj fromUser) {
        this.fromUser = fromUser;
    }

    public BaseUserObj getToUser() {
        return this.toUser;
    }

    public void setToUser(BaseUserObj toUser) {
        this.toUser = toUser;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public AddForwardingResponse createResponse() {
        return new AddForwardingResponse();
    }

    @Override
    public TimeZone getObjectTimeZone() {
        return this.timeZone;
    }

    public AddForwardingRequest withAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public AddForwardingRequest withFromUser(BaseUserObj fromUser) {
        this.fromUser = fromUser;
        return this;
    }

    public AddForwardingRequest withToUser(BaseUserObj toUser) {
        this.toUser = toUser;
        return this;
    }

    public AddForwardingRequest withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    public AddForwardingRequest withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public AddForwardingRequest withTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }
}

