/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.user.forward;

import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.BaseRequest;
import com.ifountain.opsgenie.client.model.beans.ForwardingIdentifierType;
import com.ifountain.opsgenie.client.model.user.forward.GetForwardingResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class GetForwardingRequest
extends BaseRequest<GetForwardingResponse, GetForwardingRequest> {
    private String identifier;
    private String identifierType;

    @Override
    public void validate() throws OpsGenieClientValidationException {
        super.validate();
        if (StringUtils.isNotEmpty((CharSequence)this.identifierType) && Objects.isNull((Object)ForwardingIdentifierType.getFromValues(this.identifierType))) {
            throw OpsGenieClientValidationException.invalidValues("identifierType");
        }
        if (StringUtils.isEmpty((CharSequence)this.identifier)) {
            throw OpsGenieClientValidationException.missingMultipleMandatoryProperty("alias", "id");
        }
    }

    @Override
    public Map<String, Object> getRequestParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)this.identifierType)) {
            params.put("identifierType", this.identifierType);
        } else {
            params.put("identifierType", "id");
        }
        return params;
    }

    @Override
    public String getEndPoint() {
        return "/v2/forwarding-rules/" + this.identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifierType() {
        return this.identifierType;
    }

    public void setIdentifierType(String identifierType) {
        this.identifierType = identifierType;
    }

    @Override
    public GetForwardingResponse createResponse() {
        return new GetForwardingResponse();
    }

    public GetForwardingRequest withIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public GetForwardingRequest withIdentifierType(String identifierType) {
        this.identifierType = identifierType;
        return this;
    }
}

