/*
 * Decompiled with CFR 0.152.
 */
package com.ifountain.opsgenie.client.model.user.forward;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ifountain.opsgenie.client.OpsGenieClientValidationException;
import com.ifountain.opsgenie.client.model.BaseRequest;
import com.ifountain.opsgenie.client.model.ObjectWithTimeZone;
import com.ifountain.opsgenie.client.model.beans.BaseUserObj;
import com.ifountain.opsgenie.client.model.beans.ForwardingIdentifierType;
import com.ifountain.opsgenie.client.model.user.forward.UpdateForwardingResponse;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class UpdateForwardingRequest
extends BaseRequest<UpdateForwardingResponse, UpdateForwardingRequest>
implements ObjectWithTimeZone {
    @JsonIgnore
    private String identifier;
    @JsonIgnore
    private String identifierType;
    private BaseUserObj fromUser;
    private BaseUserObj toUser;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date startDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date endDate;
    @JsonProperty(value="timezone")
    private TimeZone timeZone = TimeZone.getTimeZone("GMT");

    @Override
    public String getEndPoint() {
        return "/v2/forwarding-rules/" + this.identifier;
    }

    @Override
    public void validate() throws OpsGenieClientValidationException {
        super.validate();
        if (StringUtils.isNotEmpty((CharSequence)this.identifierType) && Objects.isNull((Object)ForwardingIdentifierType.getFromValues(this.identifierType))) {
            throw OpsGenieClientValidationException.invalidValues("identifierType");
        }
        if (StringUtils.isEmpty((CharSequence)this.identifier)) {
            throw OpsGenieClientValidationException.missingMultipleMandatoryProperty("alias", "id");
        }
        if (this.fromUser == null) {
            throw OpsGenieClientValidationException.missingMandatoryProperty("fromUser");
        }
        if (StringUtils.isEmpty((CharSequence)this.fromUser.getUsername()) && StringUtils.isEmpty((CharSequence)this.fromUser.getId())) {
            throw OpsGenieClientValidationException.error("Either username or id in from user is mandatory");
        }
        if (this.toUser == null) {
            throw OpsGenieClientValidationException.missingMandatoryProperty("toUser");
        }
        if (StringUtils.isEmpty((CharSequence)this.toUser.getUsername()) && StringUtils.isEmpty((CharSequence)this.toUser.getId())) {
            throw OpsGenieClientValidationException.error("Either username or id in to user is mandatory");
        }
        if (this.startDate == null || this.endDate == null) {
            throw OpsGenieClientValidationException.missingMultipleMandatoryProperty("startDate", "endDate");
        }
        if (this.startDate.before(Calendar.getInstance().getTime())) {
            throw OpsGenieClientValidationException.error("Start Time can not be before now.");
        }
        if (this.startDate.after(this.endDate)) {
            throw OpsGenieClientValidationException.error("End time should be later than start time.");
        }
    }

    @Override
    public Map<String, Object> getRequestParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)this.identifierType)) {
            params.put("identifierType", this.identifierType);
        } else {
            params.put("identifierType", "id");
        }
        return params;
    }

    public String getIdentifierType() {
        return this.identifierType;
    }

    public void setIdentifierType(String identifierType) {
        this.identifierType = identifierType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public BaseUserObj getFromUser() {
        return this.fromUser;
    }

    public void setFromUser(BaseUserObj fromUser) {
        this.fromUser = fromUser;
    }

    public BaseUserObj getToUser() {
        return this.toUser;
    }

    public void setToUser(BaseUserObj toUser) {
        this.toUser = toUser;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public TimeZone getObjectTimeZone() {
        return this.timeZone;
    }

    public UpdateForwardingRequest withIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public UpdateForwardingRequest withIdentifierType(String identifierType) {
        this.identifierType = identifierType;
        return this;
    }

    public UpdateForwardingRequest withFromUser(BaseUserObj fromUser) {
        this.fromUser = fromUser;
        return this;
    }

    public UpdateForwardingRequest withToUser(BaseUserObj toUser) {
        this.toUser = toUser;
        return this;
    }

    public UpdateForwardingRequest withStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    public UpdateForwardingRequest withEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public UpdateForwardingRequest withTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @Override
    public UpdateForwardingResponse createResponse() {
        return new UpdateForwardingResponse();
    }
}

