/*
 * Decompiled with CFR 0.152.
 */
package com.opsgenie.aws.core.property;

import com.opsgenie.core.property.FileSystemAwarePropertyAccessor;
import java.io.File;

public class AwsHomeAwarePropertyAccessor
extends FileSystemAwarePropertyAccessor {
    private static final String AWS_HOME_DIR = System.getProperty("user.home") + File.separator + System.getProperty("opsgenie.aws.home", ".aws");
    private static final String CREDENTIALS_FILE_NAME = System.getProperty("opsgenie.aws.credentialsFileName", "credentials");

    public AwsHomeAwarePropertyAccessor() {
        this(AWS_HOME_DIR, CREDENTIALS_FILE_NAME);
    }

    public AwsHomeAwarePropertyAccessor(String credentialsFileName) {
        this(AWS_HOME_DIR, credentialsFileName);
    }

    public AwsHomeAwarePropertyAccessor(String awsHomeDir, String credentialsFileName) {
        super(awsHomeDir, credentialsFileName);
    }

    public String getProperty(String propName) {
        if ("aws.client.accessKey".equals(propName)) {
            return super.getProperty("aws_access_key_id");
        }
        if ("aws.client.secretKey".equals(propName)) {
            return super.getProperty("aws_secret_access_key");
        }
        return super.getProperty(propName);
    }
}

