/*
 * Decompiled with CFR 0.152.
 */
package com.opsgenie.aws.core.property;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.util.StringUtils;
import com.opsgenie.aws.core.property.AwsProperties;
import com.opsgenie.aws.core.property.StandardAwsClientPropertyAccessor;
import com.opsgenie.core.property.PropertyAccessor;
import java.util.Map;

public enum AwsPropertyAccessors implements PropertyAccessor,
AwsProperties
{
    STANDARD_AWS_CLIENT((PropertyAccessor)new StandardAwsClientPropertyAccessor());

    private static final AWSCredentials STANDARD_CREDENTIALS;
    private PropertyAccessor propertyAccessor;

    private AwsPropertyAccessors(PropertyAccessor propertyAccessor) {
        this.propertyAccessor = propertyAccessor;
    }

    public String getAccessKey() {
        return this.getProperty("aws.client.accessKey");
    }

    public String getSecretKey() {
        return this.getProperty("aws.client.secretKey");
    }

    public String getRegion() {
        return this.getProperty("aws.client.region");
    }

    public String getProperty(String propName) {
        return this.propertyAccessor.getProperty(propName);
    }

    public Map<String, String> getProperties() {
        return this.propertyAccessor.getProperties();
    }

    private static AWSCredentials getStandardCredentials() {
        String accessKey = STANDARD_AWS_CLIENT.getProperty("aws.client.accessKey");
        String secretKey = STANDARD_AWS_CLIENT.getProperty("aws.client.secretKey");
        if (StringUtils.isNullOrEmpty((String)accessKey) || StringUtils.isNullOrEmpty((String)secretKey)) {
            return null;
        }
        return new BasicAWSCredentials(accessKey, secretKey);
    }

    public static AWSCredentialsProvider getDefaultCredentialsProvider() {
        if (STANDARD_CREDENTIALS == null) {
            return DefaultAWSCredentialsProviderChain.getInstance();
        }
        return new AWSStaticCredentialsProvider(STANDARD_CREDENTIALS);
    }

    public static AWSCredentials getDefaultCredentials() {
        return AwsPropertyAccessors.getDefaultCredentialsProvider().getCredentials();
    }

    static {
        STANDARD_CREDENTIALS = AwsPropertyAccessors.getStandardCredentials();
    }
}

