/*
 * Decompiled with CFR 0.152.
 */
package com.opsgenie.aws.core.property;

import com.opsgenie.aws.core.property.AwsHomeAwarePropertyAccessor;
import com.opsgenie.aws.core.property.AwsProperties;
import com.opsgenie.core.property.ClassPathAwarePropertyAccessor;
import com.opsgenie.core.property.CombinedPropertyAccessor;
import com.opsgenie.core.property.PropertyAccessor;
import com.opsgenie.core.property.ProvidedPropertyAccessor;
import com.opsgenie.core.property.StandardPropertyAccessor;
import com.opsgenie.core.property.SystemEnvironmentAwarePropertyAccessor;
import com.opsgenie.core.property.SystemPropertyAwarePropertyAccessor;
import com.opsgenie.core.property.UserHomeAwarePropertyAccessor;
import com.opsgenie.core.property.provider.ProfileProvider;
import java.util.ArrayList;
import java.util.List;

public class StandardAwsClientPropertyAccessor
extends CombinedPropertyAccessor
implements AwsProperties {
    public StandardAwsClientPropertyAccessor() {
        super(StandardAwsClientPropertyAccessor.createStandardPropertyAccessors("aws-client.properties", ProfileProvider.getProfile()));
    }

    public StandardAwsClientPropertyAccessor(String propFileName) {
        super(StandardAwsClientPropertyAccessor.createStandardPropertyAccessors(propFileName, ProfileProvider.getProfile()));
    }

    public StandardAwsClientPropertyAccessor(String propFileName, String profileName) {
        super(StandardAwsClientPropertyAccessor.createStandardPropertyAccessors(propFileName, profileName));
    }

    private static List<PropertyAccessor> createStandardPropertyAccessors(String propFileName, String profileName) {
        ArrayList<PropertyAccessor> propertyAccessors = new ArrayList<PropertyAccessor>();
        propertyAccessors.add((PropertyAccessor)ProvidedPropertyAccessor.INSTANCE);
        propertyAccessors.add((PropertyAccessor)new SystemPropertyAwarePropertyAccessor());
        propertyAccessors.add((PropertyAccessor)new SystemEnvironmentAwarePropertyAccessor());
        if (propFileName != null) {
            propertyAccessors.add((PropertyAccessor)new UserHomeAwarePropertyAccessor(propFileName, profileName));
            propertyAccessors.add((PropertyAccessor)new ClassPathAwarePropertyAccessor(propFileName, profileName));
        }
        propertyAccessors.add((PropertyAccessor)new UserHomeAwarePropertyAccessor(StandardPropertyAccessor.BASE_CONFIG_FILE, profileName));
        propertyAccessors.add((PropertyAccessor)new ClassPathAwarePropertyAccessor(StandardPropertyAccessor.BASE_CONFIG_FILE, profileName));
        propertyAccessors.add((PropertyAccessor)new AwsHomeAwarePropertyAccessor());
        return propertyAccessors;
    }
}

