/*
 * Decompiled with CFR 0.152.
 */
package com.opswat.metadefender.core.client;

import com.opswat.metadefender.core.client.exceptions.MetadefenderClientException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class HttpConnector {
    private static final int BUFFER_SIZE = 4096;

    public HttpResponse sendRequest(String url, String method, InputStream inputStream, Map<String, String> headers) throws MetadefenderClientException {
        HttpURLConnection conn = null;
        try {
            String output;
            int responseCode;
            URL u = new URL(url);
            conn = (HttpURLConnection)u.openConnection();
            conn.setRequestMethod(method);
            conn.setRequestProperty("Accept", "application/json");
            if (headers != null && !headers.isEmpty()) {
                for (String key : headers.keySet()) {
                    conn.setRequestProperty(key, headers.get(key));
                }
            }
            if (inputStream != null) {
                conn.setDoOutput(true);
                OutputStream os = conn.getOutputStream();
                HttpConnector.copyStream(inputStream, os);
                os.flush();
            }
            BufferedReader br = 200 <= (responseCode = conn.getResponseCode()) && responseCode <= 299 ? new BufferedReader(new InputStreamReader(conn.getInputStream())) : new BufferedReader(new InputStreamReader(conn.getErrorStream()));
            String response = "";
            while ((output = br.readLine()) != null) {
                response = response + output;
            }
            conn.disconnect();
            HttpResponse httpResponse = new HttpResponse(response, responseCode);
            return httpResponse;
        }
        catch (IOException e) {
            throw new MetadefenderClientException("Cannot connect to: " + url + " " + e.getMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public HttpResponse sendRequest(String url, String method) throws MetadefenderClientException {
        return this.sendRequest(url, method, null, new HashMap<String, String>());
    }

    public HttpResponse sendRequest(String url, String method, byte[] body) throws MetadefenderClientException {
        return this.sendRequest(url, method, new ByteArrayInputStream(body), new HashMap<String, String>());
    }

    protected static void copyStream(InputStream from, OutputStream to) throws IOException {
        int bytesRead;
        byte[] buf = new byte[4096];
        do {
            if ((bytesRead = from.read(buf)) <= -1) continue;
            to.write(buf, 0, bytesRead);
        } while (bytesRead > -1);
    }

    public static class HttpResponse {
        String response;
        int responseCode;

        public HttpResponse(String response, int responseCode) {
            this.response = response;
            this.responseCode = responseCode;
        }
    }
}

