/*
 * Decompiled with CFR 0.152.
 */
package com.opswat.metadefender.core.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.opswat.metadefender.core.client.FileScanOptions;
import com.opswat.metadefender.core.client.HttpConnector;
import com.opswat.metadefender.core.client.exceptions.MetadefenderClientException;
import com.opswat.metadefender.core.client.responses.ApiVersion;
import com.opswat.metadefender.core.client.responses.EngineVersion;
import com.opswat.metadefender.core.client.responses.FileScanResult;
import com.opswat.metadefender.core.client.responses.License;
import com.opswat.metadefender.core.client.responses.ScanRule;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class MetadefenderCoreClient {
    public static final String DATE_FORMAT_MILLIS_RESOLUTION = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String DATE_FORMAT_DAY_RESOLUTION = "MM/dd/yyyy";
    private HttpConnector httpConnector = new HttpConnector();
    private final String apiEndPointUrl;
    private String sessionId = null;
    private String user_agent = null;

    public MetadefenderCoreClient(String apiEndPointUrl) {
        this.apiEndPointUrl = apiEndPointUrl;
    }

    public MetadefenderCoreClient(String apiEndPointUrl, String apiKey) {
        this.apiEndPointUrl = apiEndPointUrl;
        this.sessionId = apiKey;
    }

    public MetadefenderCoreClient(String apiEndPointUrl, String userName, String password) throws MetadefenderClientException {
        this.apiEndPointUrl = apiEndPointUrl;
        this.login(userName, password);
    }

    public void setHttpConnector(HttpConnector httpConnector) {
        if (httpConnector == null) {
            throw new InvalidParameterException("httpConnector cannot be null");
        }
        this.httpConnector = httpConnector;
    }

    public void setUserAgent(String user_agent) {
        this.user_agent = user_agent;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void login(String userName, String password) throws MetadefenderClientException {
        ObjectMapper mapper = this.getObjectMapper();
        ObjectNode loginJson = mapper.createObjectNode();
        loginJson.put("user", userName);
        loginJson.put("password", password);
        String body = loginJson.toString();
        HttpConnector.HttpResponse response = this.httpConnector.sendRequest(this.apiEndPointUrl + "/login", "POST", body.getBytes());
        if (response.responseCode == 200) {
            JsonNode actualObj = this.getJsonFromString(response.response);
            this.sessionId = actualObj.get("session_id").asText();
        } else {
            this.throwRequestError(response);
        }
    }

    public boolean validateCurrentSession() throws MetadefenderClientException {
        if (this.sessionId == null || this.sessionId.isEmpty()) {
            return false;
        }
        HttpConnector.HttpResponse response = this.httpConnector.sendRequest(this.apiEndPointUrl + "/version", "GET", null, this.getLoggedInHeader());
        return response.responseCode == 200;
    }

    public String scanFile(InputStream inputStream, FileScanOptions fileScanOptions) throws MetadefenderClientException {
        if (inputStream == null) {
            throw new MetadefenderClientException("Stream cannot be null");
        }
        if (fileScanOptions != null && fileScanOptions.getUserAgent() == null && this.user_agent != null) {
            fileScanOptions.setUserAgent(this.user_agent);
        }
        if (fileScanOptions == null && this.user_agent != null) {
            fileScanOptions = new FileScanOptions().setUserAgent(this.user_agent);
        }
        Map<String, String> headers = fileScanOptions == null ? null : fileScanOptions.getOptions();
        HttpConnector.HttpResponse response = this.httpConnector.sendRequest(this.apiEndPointUrl + "/file", "POST", inputStream, headers);
        if (response.responseCode == 200) {
            JsonNode actualObj = this.getJsonFromString(response.response);
            return actualObj.get("data_id").asText();
        }
        this.throwRequestError(response);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileScanResult scanFileSync(InputStream inputStream, FileScanOptions fileScanOptions, int pollingInterval, int timeout) throws MetadefenderClientException, InterruptedException, ExecutionException, TimeoutException {
        String data_id = this.scanFile(inputStream, fileScanOptions);
        FileScanResult fileScanResult = null;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<FileScanResult> future = executor.submit(new FetchScanResultTask(data_id, pollingInterval));
        try {
            fileScanResult = future.get(timeout, TimeUnit.MILLISECONDS);
        }
        finally {
            future.cancel(true);
            executor.shutdownNow();
        }
        return fileScanResult;
    }

    public FileScanResult fetchScanResult(String data_id) throws MetadefenderClientException {
        if (data_id == null || data_id.isEmpty()) {
            throw new MetadefenderClientException("data_id is required");
        }
        HttpConnector.HttpResponse response = this.httpConnector.sendRequest(this.apiEndPointUrl + "/file/" + data_id, "GET");
        if (response.responseCode == 200) {
            JsonNode actualObj = this.getJsonFromString(response.response);
            if (actualObj.has(data_id)) {
                return null;
            }
            return this.getObjectFromJson(response.response, FileScanResult.class);
        }
        this.throwRequestError(response);
        return null;
    }

    public FileScanResult fetchScanResultByHash(String hash) throws MetadefenderClientException {
        if (hash == null || hash.isEmpty()) {
            throw new MetadefenderClientException("Hash is required");
        }
        HttpConnector.HttpResponse response = this.httpConnector.sendRequest(this.apiEndPointUrl + "/hash/" + hash, "GET");
        if (response.responseCode == 200) {
            JsonNode actualObj = this.getJsonFromString(response.response);
            if (actualObj.has(hash)) {
                return null;
            }
            return this.getObjectFromJson(response.response, FileScanResult.class);
        }
        this.throwRequestError(response);
        return null;
    }

    public License getCurrentLicenseInformation() throws MetadefenderClientException {
        this.checkSession();
        HttpConnector.HttpResponse response = this.httpConnector.sendRequest(this.apiEndPointUrl + "/admin/license", "GET", null, this.getLoggedInHeader());
        if (response.responseCode == 200) {
            return this.getObjectFromJson(response.response, License.class);
        }
        this.throwRequestError(response);
        return null;
    }

    public List<EngineVersion> getEngineVersions() throws MetadefenderClientException {
        HttpConnector.HttpResponse response = this.httpConnector.sendRequest(this.apiEndPointUrl + "/stat/engines", "GET");
        if (response.responseCode == 200) {
            return this.getCollectionFromJson(response.response, new TypeReference<List<EngineVersion>>(){});
        }
        this.throwRequestError(response);
        return null;
    }

    public ApiVersion getVersion() throws MetadefenderClientException {
        this.checkSession();
        HttpConnector.HttpResponse response = this.httpConnector.sendRequest(this.apiEndPointUrl + "/version", "GET", null, this.getLoggedInHeader());
        if (response.responseCode == 200) {
            return this.getObjectFromJson(response.response, ApiVersion.class);
        }
        this.throwRequestError(response);
        return null;
    }

    public List<ScanRule> getAvailableScanRules() throws MetadefenderClientException {
        HttpConnector.HttpResponse response = this.httpConnector.sendRequest(this.apiEndPointUrl + "/file/rules", "GET");
        if (response.responseCode == 200) {
            return this.getCollectionFromJson(response.response, new TypeReference<List<ScanRule>>(){});
        }
        this.throwRequestError(response);
        return null;
    }

    public void logout() throws MetadefenderClientException {
        this.checkSession();
        HttpConnector.HttpResponse response = this.httpConnector.sendRequest(this.apiEndPointUrl + "/logout", "POST", null, this.getLoggedInHeader());
        this.sessionId = null;
        if (response.responseCode != 200) {
            this.throwRequestError(response);
        }
    }

    private Map<String, String> getLoggedInHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("apikey", this.sessionId);
        return headers;
    }

    private void throwRequestError(HttpConnector.HttpResponse response) throws MetadefenderClientException {
        JsonNode actualObj = this.getJsonFromString(response.response);
        String errorMessage = actualObj.get("err").asText();
        throw new MetadefenderClientException(errorMessage, response.responseCode);
    }

    private void checkSession() throws MetadefenderClientException {
        if (this.sessionId == null || this.sessionId.isEmpty()) {
            throw new MetadefenderClientException("You need to be logged in to access this API point.");
        }
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    private JsonNode getJsonFromString(String json) throws MetadefenderClientException {
        ObjectMapper mapper = this.getObjectMapper();
        try {
            return mapper.readTree(json);
        }
        catch (IOException e) {
            throw new MetadefenderClientException("Cannot parse json: " + e.getMessage());
        }
    }

    private <T> T getObjectFromJson(String json, Class<T> clazz) throws MetadefenderClientException {
        ObjectMapper mapper = this.getObjectMapper();
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new MetadefenderClientException("Cannot parse json: " + e.getMessage());
        }
    }

    private <T> List<T> getCollectionFromJson(String json, TypeReference<List<T>> typeReference) throws MetadefenderClientException {
        try {
            ObjectMapper mapper = this.getObjectMapper();
            return (List)mapper.readValue(json, typeReference);
        }
        catch (IOException e) {
            throw new MetadefenderClientException("Cannot parse json: " + e.getMessage());
        }
    }

    public class FetchScanResultTask
    implements Callable<FileScanResult> {
        private final String data_id;
        private final int pollingInterval;

        public FetchScanResultTask(String data_id, int pollingInterval) {
            this.data_id = data_id;
            this.pollingInterval = pollingInterval;
        }

        @Override
        public FileScanResult call() throws Exception {
            FileScanResult fileScanResult;
            while ((fileScanResult = MetadefenderCoreClient.this.fetchScanResult(this.data_id)) == null || !fileScanResult.isScanFinished()) {
                TimeUnit.MILLISECONDS.sleep(this.pollingInterval);
            }
            return fileScanResult;
        }
    }
}

