/*
 * Decompiled with CFR 0.152.
 */
package com.opswat.metadefender.core.clientexample;

import com.opswat.metadefender.core.client.HttpConnector;
import com.opswat.metadefender.core.client.exceptions.MetadefenderClientException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class CustomHttpConnector
extends HttpConnector {
    @Override
    public HttpConnector.HttpResponse sendRequest(String url, String method, InputStream inputStream, Map<String, String> headers) throws MetadefenderClientException {
        try {
            String output;
            URL u = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            conn.setRequestMethod(method);
            conn.setRequestProperty("Accept", "application/json");
            if (headers != null && !headers.isEmpty()) {
                for (String key : headers.keySet()) {
                    conn.setRequestProperty(key, headers.get(key));
                }
            }
            if (inputStream != null) {
                conn.setDoOutput(true);
                OutputStream os = conn.getOutputStream();
                CustomHttpConnector.copyStream(inputStream, os);
                os.flush();
            }
            BufferedReader br = 200 <= conn.getResponseCode() && conn.getResponseCode() <= 299 ? new BufferedReader(new InputStreamReader(conn.getInputStream())) : new BufferedReader(new InputStreamReader(conn.getErrorStream()));
            String response = "";
            while ((output = br.readLine()) != null) {
                response = response + output;
            }
            conn.disconnect();
            return new HttpConnector.HttpResponse(response, conn.getResponseCode());
        }
        catch (IOException e) {
            throw new MetadefenderClientException("Cannot connect to: " + url + " " + e.getMessage());
        }
    }
}

