/*
 * Decompiled with CFR 0.152.
 */
package com.opswat.metadefender.core.clientexample;

import com.opswat.metadefender.core.client.FileScanOptions;
import com.opswat.metadefender.core.client.MetadefenderCoreClient;
import com.opswat.metadefender.core.client.exceptions.MetadefenderClientException;
import com.opswat.metadefender.core.client.responses.ApiVersion;
import com.opswat.metadefender.core.client.responses.EngineVersion;
import com.opswat.metadefender.core.client.responses.FileScanResult;
import com.opswat.metadefender.core.client.responses.License;
import com.opswat.metadefender.core.client.responses.ScanRule;
import com.opswat.metadefender.core.clientexample.CustomHttpConnector;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class Example {
    public static void main(String[] args) {
        try {
            Example.scanFileSync("http://localhost:8008", "C:\\icap.log");
        }
        catch (InterruptedException e) {
            System.out.println("Interrupted");
        }
        catch (ExecutionException e) {
            System.out.println("Exception during the operation " + e.getMessage());
        }
        catch (TimeoutException e) {
            System.out.println("Process timeout");
        }
    }

    private static void scanFileSync(String apiUrl, String file) throws InterruptedException, ExecutionException, TimeoutException {
        MetadefenderCoreClient metadefenderCoreClient = new MetadefenderCoreClient(apiUrl);
        try {
            FileInputStream inputStream = new FileInputStream(file);
            FileScanResult result = metadefenderCoreClient.scanFileSync(inputStream, new FileScanOptions().setFileName(Example.getFileNameFromPath(file)), 200, 300000);
            System.out.println("File scan finished with result: " + result.process_info.result);
        }
        catch (MetadefenderClientException e) {
            System.out.println("Error during file scan: " + e.getDetailedMessage());
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + file + " Exception: " + e.getMessage());
        }
    }

    private static void scanFile(String apiUrl, String file) {
        MetadefenderCoreClient metadefenderCoreClient = new MetadefenderCoreClient(apiUrl);
        metadefenderCoreClient.setHttpConnector(new CustomHttpConnector());
        try {
            FileInputStream inputStream = new FileInputStream(file);
            String dataId = metadefenderCoreClient.scanFile(inputStream, new FileScanOptions().setFileName(Example.getFileNameFromPath(file)));
            System.out.println("File scan started. The data id is: " + dataId);
        }
        catch (MetadefenderClientException e) {
            System.out.println("Error during file scan: " + e.getDetailedMessage());
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + file + " Exception: " + e.getMessage());
        }
    }

    private static void fetchScanResultByHash(String apiUrl, String hash) {
        MetadefenderCoreClient metadefenderCoreClient = new MetadefenderCoreClient(apiUrl);
        try {
            FileScanResult result = metadefenderCoreClient.fetchScanResultByHash(hash);
            if (result != null) {
                System.out.println("Fetch result by file hash: " + result.process_info.result);
            }
        }
        catch (MetadefenderClientException e) {
            System.out.println("Error during fetch scan by hash: " + e.getDetailedMessage());
        }
    }

    private static void showApiInfo(String apiUrl, String apiUser, String apiUserPass) {
        MetadefenderCoreClient metadefenderCoreClient;
        try {
            metadefenderCoreClient = new MetadefenderCoreClient(apiUrl, apiUser, apiUserPass);
            metadefenderCoreClient.setHttpConnector(new CustomHttpConnector());
            System.out.println("Metadefender client created. Session id is: " + metadefenderCoreClient.getSessionId());
        }
        catch (MetadefenderClientException e) {
            System.out.println("Cannot login to this API. Error message: " + e.getDetailedMessage());
            return;
        }
        try {
            License license = metadefenderCoreClient.getCurrentLicenseInformation();
            System.out.println("Licensed to: " + license.licensed_to);
        }
        catch (MetadefenderClientException e) {
            System.out.println("Cannot get license details: " + e.getDetailedMessage());
        }
        try {
            List<EngineVersion> result = metadefenderCoreClient.getEngineVersions();
            System.out.println("Fetched engine/database versions: " + result.size());
        }
        catch (MetadefenderClientException e) {
            System.out.println("Cannot get engine/database   versions: " + e.getDetailedMessage());
        }
        try {
            ApiVersion apiVersion = metadefenderCoreClient.getVersion();
            System.out.println("Api endpoint apiVersion: " + apiVersion.version);
        }
        catch (MetadefenderClientException e) {
            System.out.println("Cannot get api endpoint version: " + e.getDetailedMessage());
        }
        try {
            List<ScanRule> scanRules = metadefenderCoreClient.getAvailableScanRules();
            System.out.println("Available scan rules: " + scanRules.size());
        }
        catch (MetadefenderClientException e) {
            System.out.println("Cannot get available scan rules: " + e.getDetailedMessage());
        }
        try {
            metadefenderCoreClient.logout();
            System.out.println("Client successfully logged out.");
        }
        catch (MetadefenderClientException e) {
            System.out.println("Cannot log out: " + e.getDetailedMessage());
        }
    }

    public static void printUsage(String message) {
        if (message != null) {
            System.out.println(message);
        }
        System.out.println("\n\n\nExample usages: \n\n  Example -h http://localhost:8008 -a scan -f fileToScan\n  Example -h http://localhost:8008 -u yourUser -p yourPass -a info\n\n\n\t  -h   host                    Required\n\t  -u   username                Required if action is 'info'\n\t  -p   password                Required if action is 'info'\n\t  -a   action to do            Required (scan|scan_sync|info|hash)\n\t  -f   path to file to scan    Required if action is (scan|scan_sync)\t  -m   hash (md5|sha1|sha256)  Required if action is (hash)\n\n\n");
    }

    private static Map<String, String> processArguments(String[] args) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        List<String> switches = Arrays.asList("-h", "-u", "-p", "-a", "-f", "-m");
        for (String switchStr : switches) {
            int index = Example.getSwitchIndex(args, switchStr);
            if (index < 0) continue;
            if (args.length >= index + 1) {
                parameters.put(switchStr, args[index + 1]);
                continue;
            }
            Example.printUsage("Missing value for switch: " + switchStr);
            System.exit(1);
        }
        if (!parameters.containsKey("-h")) {
            Example.printUsage("-h is required");
            System.exit(1);
        }
        if (!parameters.containsKey("-a")) {
            Example.printUsage("-a is required");
            System.exit(1);
        }
        String action = (String)parameters.get("-a");
        List<String> allowedActions = Arrays.asList("scan", "scan_sync", "info", "hash");
        if (!allowedActions.contains(action)) {
            Example.printUsage("Invalid action: " + action);
            System.exit(1);
        }
        if ("info".equals(action)) {
            if (!parameters.containsKey("-u")) {
                Example.printUsage("-u is required");
                System.exit(1);
            }
            if (!parameters.containsKey("-p")) {
                Example.printUsage("-p is required");
                System.exit(1);
            }
        }
        if (("scan".equals(action) || "scan_sync".equals(action)) && !parameters.containsKey("-f")) {
            Example.printUsage("-f is required");
            System.exit(1);
        }
        if ("hash".equals(action) && !parameters.containsKey("-m")) {
            Example.printUsage("-m is required");
            System.exit(1);
        }
        return parameters;
    }

    private static int getSwitchIndex(String[] args, String switchStr) {
        for (int i = 0; i < args.length; ++i) {
            if (!switchStr.equals(args[i])) continue;
            return i;
        }
        return -1;
    }

    private static String getFileNameFromPath(String file) {
        String[] parts;
        if (file.contains("/")) {
            parts = file.split("/");
        } else if (file.contains("\\")) {
            parts = file.split("\\\\");
        } else {
            return file;
        }
        if (parts.length > 1) {
            return parts[parts.length - 1];
        }
        return file;
    }
}

