// Copyright 2014,2015 ~ Optersoft SL

package os.serial

import os.serial.internal.Bytes._
import os.serial.internal.Serialize
import os.serial.internal.Reify
import os.serial.internal.Id

/**
 *
 * Add @id to each non-transient property
 * 0-15 1 byte, 15- ... 2 bytes
 *
 */
abstract class Serial {

  @transient val $bytes: Array[Byte] = null

  @transient val $index = 0

}

object Serial {

  def deleteField(bytes: Array[Byte], id: Int, index: Int = 0) = ???

  def id[S <: Serial](): Int = macro Id.getClassId[S]

  def id[S <: Serial](name: String): Int = macro Id.getFieldId[S]

  def reify[S <: Serial](bytes: Array[Byte], index: Int = 0): S = Reify[S](bytes, index)

  def reifyField[T](bytes: Array[Byte], id: Int, index: Int = 0): T = Reify.field[T](bytes, id, index)

  def reifyFieldInt(bytes: Array[Byte], id: Int, index: Int) = Reify.fieldInt(bytes, id, index)

  def serialize(serial: Serial): Array[Byte] = Serialize(serial)

  def serializeField(bytes: Array[Byte], id: Int, value: Any, index: Int = 0) = ???

}