// Copyright 2014,2015 ~ Optersoft SL

package os.serial.internal

import java.lang.reflect.Field

class Attribute(val field: Field) {

  field.setAccessible(true)

  val id = field.getAnnotation(classOf[os.serial.id]).value()

  lazy val option =
    field.getType.isAssignableFrom(classOf[Option[_]])

  lazy val sequence = field.getType().isAssignableFrom(classOf[Seq[_]])

//  lazy val target: Class[_] = {
//    val ann = field.getAnnotation(classOf[os.reflect.target])
//    if (ann != null) ann.value else
//      field.getType
//  }

  def get(any: AnyRef) = {

    field.get(any) match {
      case null => null
      case None => null
      case Some(value) => value
      case seq: Seq[_] if seq.isEmpty => null
      case other => other
    }
  }

  override def toString = field.getName

  // def set(ref: AnyRef, value: Any) {
  //
  // try {
  //
  // if (option) {
  // value match {
  // case option: Option[_] => field.set(ref, value)
  // case null => field.set(ref, None)
  // case other => field.set(ref, Some(value))
  // }
  // } else {
  //
  // field.set(ref, value)
  // }
  // } catch {
  // case e: IllegalArgumentException =>
  //
  // // try implicit conversion
  // // TODO add @ to implicit method if serial
  //
  // try {
  //
  // val module = Reflect.getCompanionObject(field.getType())
  // module.getClass.getDeclaredMethods().find { method =>
  // val parameters = method.getParameterTypes()
  // parameters.length == 1 &&
  // parameters(0).isAssignableFrom(value.getClass) &&
  // method.getReturnType().isAssignableFrom(field.getType())
  //
  // } match {
  // case None => throw e
  // case Some(method) =>
  // val newValue = method.invoke(module, value.asInstanceOf[Object])
  // set(ref, newValue)
  // }
  // } catch {
  // case notFound: ClassNotFoundException => throw e
  // }
  // }
  // }

  // OLD CODE

  //    lazy val types: Array[Class[_]] = {
  //    val anns = field.getAnnotation(classOf[Types])
  //    if (anns != null)
  //      Array(field.getType()) ++ anns.value
  //    else
  //      Array(field.getType())
  //  }
  //  // TODO tmp pathc. target annotation is not writed for classes in base
  //  lazy val target = types.last
  //
  //  // Option | One | Many
  //  lazy val sequence = field.getType().isAssignableFrom(classOf[Seq[_]])
  //  lazy val option = {
  //    val clazz = field.getType()
  //    if (clazz == classOf[Object]) false else clazz.isAssignableFrom(classOf[Option[_]])
  //  }
  //
  //  lazy val value = classOf[Value].isAssignableFrom(target) //target.isAssignableFrom(classOf[Value])
  //
  //  lazy val index = field.getAnnotation(classOf[Index]) != null
  //
  //  lazy val component = field.getAnnotation(classOf[os.component]) != null
  //
  //  def get(anyRef: AnyRef): Any = field.get(anyRef) match {
  //    case None => null
  //    case Some(value) => value
  //    case value => value
  //  }
  //
  //  def apply(anyRef: AnyRef, recursive: Boolean = false)(f: Any => Unit) {
  //
  //    var value = field.get(anyRef)
  //    value match {
  //      case null =>
  //      case None =>
  //      case Some(value) => f(value)
  //      case seq: Seq[_] =>
  //        if (recursive)
  //          for (item <- seq) f(item)
  //        else
  //          f(seq)
  //      case value => f(value)
  //    }
  //  }
  //
  //  def set(ref: AnyRef, value: Any) {
  //
  //    try {
  //
  //      if (option) {
  //        value match {
  //          case option: Option[_] => field.set(ref, value)
  //          case null => field.set(ref, None)
  //          case other => field.set(ref, Some(value))
  //        }
  //      } else {
  //
  //        field.set(ref, value)
  //      }
  //    } catch {
  //      case e: IllegalArgumentException =>
  //
  //        // try implicit conversion
  //        // TODO add @ to implicit method if serial
  //
  //        try {
  //
  //          val module = ClassLoader.getCompanionObject(field.getType())
  //          module.getClass.getDeclaredMethods().find { method =>
  //            val parameters = method.getParameterTypes()
  //            parameters.length == 1 &&
  //              parameters(0).isAssignableFrom(value.getClass) &&
  //              method.getReturnType().isAssignableFrom(field.getType())
  //
  //          } match {
  //            case None => throw e
  //            case Some(method) =>
  //              val newValue = method.invoke(module, value.asInstanceOf[Object])
  //              set(ref, newValue)
  //          }
  //        } catch {
  //          case notFound: ClassNotFoundException => throw e
  //        }
  //    }
  //  }
  //
  //  override def toString = name

}