// Copyright 2014,2015 ~ Optersoft SL

package os.serial.internal

class ByteBuffer {

  var array = new Array[Byte](256)
  var index = 0

  def add(byte: Byte) {
    ensureSize(index + 1)
    array(index) = byte; index += 1
  }

//  def _put(byte: Byte) {
//    array(index) = byte; index += 1
//  }

  def bytes() = {

    val result = new Array[Byte](index)
    System.arraycopy(array, 0, result, 0, index)
    result
  }

  private def ensureSize(n: Int) {
    if (n > array.length)
      increaseSize(n)
  }

  def needs(needs: Int) {
    val n = index + needs
    if (n > array.length)
      increaseSize(n)
  }

  private def increaseSize(n: Int) {

    var newSize = array.length * 2
    while (n > newSize)
      newSize = newSize * 2

    val newArray = new Array[Byte](newSize)
    System.arraycopy(array, 0, newArray, 0, index)
    array = newArray
  }
}