// Copyright 2015 ~ Optersoft SL

package os.serial.internal

object Debug extends Types {

  private val Hex = Array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F')

  def printByte(b: Byte) {
    val chars = Array(Hex((b >> 4) & 0x0f), Hex(b & 0xF))
    println(new String(chars))
  }

  def printBytes(bytes: Array[Byte], index: Int = 0) {

    val sb = new StringBuilder()

    val index1 = if (index == -1) -1 else index + 1

    var i = 0; while (i < bytes.length) {

      if (i == index) sb.append('[')
      else if (i == index1) sb.append(']')
      else sb.append(' ')

      val b = bytes(i)
      sb.append(Hex((b >> 4) & 0x0f))
      sb.append(Hex(b & 0xF))

      i += 1
    }

    println(sb)

  }

  def printTypeId(bytes: Array[Byte], index: Int) {

    val sb = new StringBuilder()
    sb ++= index.toString(); sb ++= ": "

    val byte = bytes(index)
    val tpe = byte & 0xE0
    tpe match {
      case SERIAL => sb ++= "SERIAL"
      case INTEGER => sb ++= "INTEGER"
      case DECIMAL => sb ++= "DECIMAL"
      case STRING => sb ++= "STRING"

      case _ => sb ++= tpe.toHexString; sb += '?'
    }

    var id = byte & 0xF

    if ((byte & 0x10) != 0) {
      var shift = 4; var i = index + 1
      while (shift < 32) {
        val b = bytes(i) & 0xff; i += 1
        id |= (b & 0x7F) << shift
        if ((b & 0x80) == 0)
          shift = 32
        shift += 7
      }
    }

    sb += ' '
    sb ++= id.toHexString

    println(sb)

  }

}