// Copyright 2013,2015 ~ Optersoft SL

package os.serial.internal

import scala.reflect.macros._
import java.security.SecureRandom
import os.serial.id
import os.serial.Serial
import scala.reflect.ClassTag
import scala.language.experimental.macros
import scala.reflect.macros._
import scala.reflect.macros.blackbox.Context
import os.serial._

object Id {

  private lazy val random = new SecureRandom()

  def getClassId[S: c.WeakTypeTag](c: Context)(): c.Expr[Int] = {

    import c.universe._

    val symbol = implicitly[c.WeakTypeTag[S]].tpe.typeSymbol

    getId(c)(symbol) match {
      case None => c.abort(c.enclosingPosition, s"@id(???) ${symbol.owner.name}.${symbol.name}")
      case Some(id) => c.Expr[Int](q"$id")

    }

  }

  def getFieldId[S: c.WeakTypeTag](c: Context)(name: c.Expr[String]): c.Expr[Int] = {

    import c.universe._

    val _name = name.tree match {
      case Literal(Constant(name: String)) => name
      case _ => c.abort(c.enclosingPosition, "Needs literal constant: " + show(name.tree))
    }

    val tpe = implicitly[c.WeakTypeTag[S]].tpe

    getField(c)(tpe, _name) match {
      case Left(msg) => c.abort(c.enclosingPosition, msg)
      case Right(id) => c.Expr[Int](q"$id")
    }

  }

  def isValid(id: Int) =
    id != 0
  //    (id & 0xff000000) == 0 &&
  //      (id & 0xff0000) != 0xff0000 && // stop byte
  //      (id | 0x00ffff) != 0x00ffff // delete byte

  def generate(): Int = {
    val id = random.nextInt() & 0xffffff
    if (isValid(id)) id else generate()
  }

  private def getField(c: Context)(tpe: c.Type, _name: String): Either[String, Int] = {

    import c.universe._

    var baseClass: Symbol = null

    tpe.baseClasses.foreach { base =>

      val termName = TermName(_name)

      val constructor = base.asClass.primaryConstructor
      if (constructor != NoSymbol)
        for (params <- constructor.asMethod.paramLists; param <- params) {
          if (param.name == termName) {
            baseClass = base
            getId(c)(param) map { id =>
              return Right(id)
            }
          }
        }

      val memberName = TermName(_name + " ")

      base.asClass.toType.decls.foreach { member =>
        if (member.name == memberName)
          getId(c)(member) map { id => return Right(id) }
      }
    }

    val msg =
      if (baseClass != null)
        s"@id(???) ${baseClass.name}.${_name}"
      else
        s"Not found: ${tpe.typeSymbol.name.decodedName.toString()}.${_name}"

    Left(msg)

  }

  private def getId(c: Context)(symbol: c.Symbol): Option[Int] = {

    import c.universe._

    val idType = typeOf[os.serial.id]

    symbol.annotations.find(_.tree.tpe =:= idType) map {
      annotation =>
        val AssignOrNamedArg(_, Literal(Constant(id: Int))) = annotation.tree.children.last
        id

    }
  }

  // Move to browser

  //  private val IntToChar = Array(
  //    'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j',
  //    'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't',
  //    'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D',
  //    'E', 'F')
  //
  //  private val CharToInt = Array(
  //    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  //    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  //    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  //    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  //    -1, 26, 27, 28, 29, 30, 31, 32, -1, -1, -1, -1, -1, -1, -1, -1,
  //    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
  //    -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
  //    15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25)

  //  def apply[S <: Serial](clazz: Class[S]) =
  //    clazz.getAnnotation(classOf[id]).value()

  // def str[S <: Serial](name: String): String = macro IdMacro.getFieldStr[S]

  //  def asString(id: Int): String = {
  //
  //    if ((id & 0xc0000000) != 0)
  //      throw new IllegalArgumentException("Bad identifier")
  //
  //    var chars = new Array[Char](6)
  //    var index = 0
  //    for (offset <- 25 to (0, -5)) {
  //      val char = (id >>> (offset)).asInstanceOf[Int] & 0x1f
  //      chars(index) = IntToChar(char)
  //      index += 1
  //
  //    }
  //
  //    new String(chars)
  //  }
  //
  //  def fromString(number: String): Int = {
  //
  //    val size = number.size
  //    if (size == 0 || size > 6)
  //      throw new NumberFormatException(number)
  //
  //    var int = 0
  //    for (char <- number) {
  //      int = int << 5
  //      val value = CharToInt(char.asInstanceOf[Int])
  //      if (value < 0)
  //        throw new NumberFormatException(number)
  //      else int += value
  //    }
  //
  //    int
  //
  //  }

  //  // TODO merge with getFieldId
  //  def getFieldStr[S: c.WeakTypeTag](c: Context)(name: c.Expr[String]): c.Expr[String] = {
  //
  //    import c.universe._
  //
  //    val _name = name.tree match {
  //      case Literal(Constant(name: String)) => name
  //      case _ => c.abort(c.enclosingPosition, "Needs literal constant: " + show(name.tree))
  //    }
  //
  //    val tpe = implicitly[c.WeakTypeTag[S]].tpe
  //
  //    getField(c)(tpe, _name) match {
  //      case Left(msg) => c.abort(c.enclosingPosition, msg)
  //      case Right(id) => c.Expr[String](q"${Id.asString(id)}")
  //    }
  //  }

}