// Copyright 2014,2015 ~ Optersoft SL

package os.serial.internal

import scala.collection.mutable.HashMap
import scala.collection.mutable.ArrayBuffer
import os.io.Input
import scala.collection.JavaConversions._
import os.serial.Serial
import os.serial.internal.Bytes._

object Metadata {

  val FileName = "serial.os"

  private lazy val map = {

    val map = new HashMap[Int, ClassInfo]

    val classes = new ArrayBuffer[ClassInfo]

    for (url <- Thread.currentThread().getContextClassLoader().getResources(FileName)) {
      read(classes, Input(url.openStream()).readAllBytes)
    }

    for (info <- classes) {
      map += info.id -> info
    }

    map
  }

  def apply(id: Int): Option[Class[_ <: Serial]] = {
    map.get(id).map(_.clazz)
  }

  def read(classes: ArrayBuffer[ClassInfo], bytes: Array[Byte]) {

    val reader = new Bytes.Reader(bytes)

    var size = reader.Int()
    while (size > 0) {
      val id = reader.Int()
      val className = reader.utf8()
      if (!classes.exists(_.id == id))
        classes += new ClassInfo(id, className)

      size -= 1
    }
  }

  def write(classes: ArrayBuffer[ClassInfo]) = {

    val writer = new Bytes.Buffer()
    wInt(writer, classes.size)
    for (info <- classes) {
      wInt(writer, info.id)
      utf8_write(writer, info.name)
    }

    writer.bytes()

  }

  class ClassInfo(val id: Int, val name: String) {

    lazy val clazz = {
      Thread.currentThread().getContextClassLoader().loadClass(name).asInstanceOf[Class[Serial]]

    }

    override def toString = s"$id:$name"
  }

}