// Copyright 2014,2015 ~ Optersoft SL

package os.serial.internal

import os.serial.Serial
import os.serial.Serial
import scala.collection.mutable.ArrayBuffer
import os.serial.Serial
import os.serial.id
import java.lang.reflect.Modifier

class Mirror(val clazz: Class[_]) {

  lazy val attributes: Seq[Attribute] =
    parent match {
      case None => declaredAttributes
      case Some(parent) => declaredAttributes ++ parent.attributes
    }

  lazy val declaredAttributes: Seq[Attribute] = {

    var attributes = new ArrayBuffer[Attribute]
    for (field <- clazz.getDeclaredFields()) {
      if (!Modifier.isTransient(field.getModifiers)) {
        val id = field.getAnnotation(classOf[os.serial.id])
        if (id != null)
          attributes += new Attribute(field)
        else
          throw new RuntimeException(s"Add @id to ${field.getDeclaringClass.getName}.${field.getName}")
      }
    }

    attributes.toSeq
  }

  val id = clazz.getAnnotation(classOf[os.serial.id]).value()

  lazy val parent: Option[Mirror] = {
    val superclass = clazz.getSuperclass()
    if (superclass == classOf[Serial]) None else
      Some(Reflect(superclass.asInstanceOf[Class[_]]))
  }

  lazy val set: Int = if (parent.isEmpty) id else parent.get.set

  private lazy val constructor = {

    val cons = clazz.getDeclaredConstructor()
    cons.setAccessible(true)
    cons

  }

  def apply(name: String): Attribute = {

    attributes.find(_.field.getName() == name) match {

      case None => throw new IllegalArgumentException(s"Attribute not found: ${clazz.getSimpleName()}.${name}")
      case Some(attribute) => attribute
    }
  }

  def newInstance(): AnyRef = constructor.newInstance().asInstanceOf[AnyRef]

  override def toString = "Mirror(" + clazz.getSimpleName + ")"
}