// Copyright 2014,2015 ~ Optersoft SL

package os.serial.internal

import os.serial.Serial
import scala.reflect.ClassTag
import scala.collection.mutable.HashMap

object Reflect {

  private val idToMirror = new HashMap[Int, Mirror]

  private val classToMirror = new java.util.HashMap[Class[_], Mirror]

  def apply(serialClass: Class[_]): Mirror = {

    var mirror = classToMirror.get(serialClass)
    if (mirror == null) {
      classToMirror.synchronized {
        mirror = classToMirror.get(serialClass)
        if (mirror == null) {
          mirror = new Mirror(serialClass)
          classToMirror.put(serialClass, mirror)
        }
      }
    }

    mirror
  }

  def apply(id: Int): Option[Mirror] = {
    var mirror = idToMirror.get(id)
    if (mirror.isEmpty) {
      Metadata(id) map { clazz =>
        val m = apply(clazz)
        idToMirror += id -> m
        mirror = Some(m)
      }

    }

    mirror

  }

  def apply[S <: Serial](implicit tag: ClassTag[S]): Mirror = apply(tag.runtimeClass)

  def apply[S <: Serial](attribute: String)(implicit tag: ClassTag[S]): Attribute =
    apply(tag.runtimeClass).apply(attribute)

}