/*
 * Decompiled with CFR 0.152.
 */
package os.serial.internal;

public class Bytes {
    private static char[] Hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void boolean_write(Buffer buffer, boolean bl) {
        if (bl) {
            buffer.add((byte)1);
        } else {
            buffer.add((byte)0);
        }
    }

    public static boolean boolean_read(byte[] byArray, int n) {
        return byArray[n] != 0;
    }

    public static double double_read(byte[] byArray, int n) {
        return Double.longBitsToDouble(Bytes.long_read(byArray, n));
    }

    public static void double_write(Buffer buffer, double d) {
        Bytes.long_write(buffer, Double.doubleToLongBits(d));
    }

    public static double float_read(byte[] byArray, int n) {
        return Float.intBitsToFloat(Bytes.int_read(byArray, n));
    }

    public static int int_read(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < 32; i += 7) {
            int n3 = byArray[n++] & 0xFF;
            n2 |= (n3 & 0x7F) << i;
            if ((n3 & 0x80) != 0) continue;
            return n2;
        }
        throw new Error("Malformed var int");
    }

    public static int int_size(byte[] byArray, int n) {
        byte by;
        byte by2 = byArray[n];
        if (by2 >= 0) {
            return 1;
        }
        if ((by = byArray[++n]) >= 0) {
            return 2;
        }
        int n2 = 2;
        int n3 = ++n + 3;
        while (n < n3) {
            ++n2;
            byte by3 = byArray[n];
            if (by3 >= 0) {
                return n2;
            }
            ++n;
        }
        throw new Error("Malformed var int");
    }

    public static int int_size(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static void int_write(byte[] byArray, int n, int n2) {
        while (true) {
            if ((n2 & 0xFFFFFF80) == 0) {
                byArray[n++] = (byte)n2;
                return;
            }
            byArray[n++] = (byte)(n2 & 0x7F | 0x80);
            n2 >>>= 7;
        }
    }

    public static void wInt(Buffer buffer, int n) {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                buffer.add((byte)n);
                return;
            }
            buffer.add((byte)(n & 0x7F | 0x80));
            n >>>= 7;
        }
    }

    public static long long_read(byte[] byArray, int n) {
        return (long)byArray[n++] << 56 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | (long)((byArray[n++] & 0xFF) << 16) | (long)((byArray[n++] & 0xFF) << 8) | (long)(byArray[n++] & 0xFF);
    }

    public static void long_write(Buffer buffer, long l) {
        buffer.needs(8);
        buffer.put((byte)(l >> 56));
        buffer.put((byte)(l >> 48));
        buffer.put((byte)(l >> 40));
        buffer.put((byte)(l >> 32));
        buffer.put((byte)(l >> 24));
        buffer.put((byte)(l >> 16));
        buffer.put((byte)(l >> 8));
        buffer.put((byte)l);
    }

    public static long longVar_read(byte[] byArray, int n) {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            int n2 = byArray[n++] & 0xFF;
            l |= (long)(n2 & 0x7F) << i;
            if ((n2 & 0x80) != 0) continue;
            return l;
        }
        throw new Error("Malformed var long");
    }

    public static int longVar_size(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public static int longVar_skip(byte[] byArray, int n) {
        for (int i = 0; i < 64; i += 7) {
            int n2;
            if (((n2 = byArray[n++] & 0xFF) & 0x80) != 0) continue;
            return n;
        }
        throw new Error("Malformed var long");
    }

    public static void longVar_write(Buffer buffer, long l) {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                buffer.add((byte)l);
                return;
            }
            buffer.add((byte)(l & 0x7FL | 0x80L));
            l >>>= 7;
        }
    }

    public static int longVar_write(byte[] byArray, int n, long l) {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                byArray[n++] = (byte)l;
                return n;
            }
            byArray[n++] = (byte)(l & 0x7FL | 0x80L);
            l >>>= 7;
        }
    }

    public static String utf8_read(byte[] byArray, int n) {
        int n2 = Bytes.int_read(byArray, n);
        int n3 = n + Bytes.int_size(byArray, n);
        n2 = n3 + n2;
        int n4 = n3;
        int n5 = 0;
        while (n4 < n2) {
            switch ((byArray[n4] & 0xFF) >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n4;
                    break;
                }
                case 12: 
                case 13: {
                    n4 += 2;
                    break;
                }
                case 14: {
                    n4 += 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ++n5;
        }
        char[] cArray = new char[n5];
        int n6 = 0;
        while (n3 < n2) {
            byte by;
            int n7;
            byte by2;
            if ((by2 = (byte)(((n7 = byArray[n3++] & 0xFF) & 0xFF) >> 4)) < 8) {
                cArray[n6++] = (char)n7;
                continue;
            }
            if (by2 == 12 || by2 == 13) {
                if (((by = byArray[n3++]) & 0xC0) != 128) {
                    throw new IllegalArgumentException();
                }
                cArray[n6++] = (char)((n7 & 0x1F) << 6 | by & 0x3F);
                continue;
            }
            if (by2 == 14) {
                by = byArray[n3++];
                byte by3 = byArray[n3++];
                if ((by & 0xC0) != 128 || (by3 & 0xC0) != 128) {
                    throw new IllegalArgumentException();
                }
                cArray[n6++] = (char)((n7 & 0xF) << 12 | (by & 0x3F) << 6 | (by3 & 0x3F) << 0);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return new String(cArray);
    }

    public static int utf8_size(byte[] byArray, int n) {
        int n2 = Bytes.int_read(byArray, n);
        return Bytes.int_size(n2) + n2;
    }

    public static void utf8_write(Buffer buffer, String string) {
        char c;
        int n;
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        Bytes.wInt(buffer, n2);
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                buffer.add((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                buffer.add((byte)(0xE0 | c >> 12 & 0xF));
                buffer.add((byte)(0x80 | c >> 6 & 0x3F));
                buffer.add((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            buffer.add((byte)(0xC0 | c >> 6 & 0x1F));
            buffer.add((byte)(0x80 | c >> 0 & 0x3F));
        }
    }

    public static class Buffer {
        public byte[] array = new byte[256];
        public int index = 0;

        public void add(byte by) {
            this.ensureSize(this.index + 1);
            this.array[this.index++] = by;
        }

        public void put(byte by) {
            this.array[this.index++] = by;
        }

        public byte[] bytes() {
            byte[] byArray = new byte[this.index];
            System.arraycopy(this.array, 0, byArray, 0, this.index);
            return byArray;
        }

        private void ensureSize(int n) {
            if (n > this.array.length) {
                this.increaseSize(n);
            }
        }

        public void needs(int n) {
            int n2 = this.index + n;
            if (n2 > this.array.length) {
                this.increaseSize(n2);
            }
        }

        private void increaseSize(int n) {
            int n2;
            for (n2 = this.array.length * 2; n > n2; n2 *= 2) {
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.array, 0, byArray, 0, this.index);
            this.array = byArray;
        }
    }

    public static class Reader {
        private int i = 0;
        private final byte[] bytes;

        public Reader(byte[] byArray) {
            this.bytes = byArray;
        }

        public int Int() {
            int n = Bytes.int_read(this.bytes, this.i);
            this.i += Bytes.int_size(n);
            return n;
        }

        public String utf8() {
            String string = Bytes.utf8_read(this.bytes, this.i);
            this.i += Bytes.utf8_size(this.bytes, this.i);
            return string;
        }
    }
}

