/*
 * Decompiled with CFR 0.152.
 */
package os.serial.internal;

import os.serial.Serial;
import os.serial.internal.Attribute;
import os.serial.internal.ByteBuffer;
import os.serial.internal.Mirror;
import os.serial.internal.Reflect$;
import os.serial.internal.Types;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Serialize$
extends Types {
    public static final Serialize$ MODULE$;

    static {
        new Serialize$();
    }

    public byte[] serialToBytes(Serial serial) {
        return this.apply(serial);
    }

    public byte[] apply(Serial serial) {
        ByteBuffer buffer = new ByteBuffer();
        buffer.add((byte)0);
        this.writeSerial(buffer, serial);
        return buffer.bytes();
    }

    /*
     * WARNING - void declaration
     */
    public int data(ByteBuffer buffer) {
        void var2_2;
        int index = buffer.index();
        buffer.add((byte)0);
        return (int)var2_2;
    }

    public void data(ByteBuffer buffer, int start, boolean updateSize) {
        int size = buffer.index() - start;
        if (size > 127) {
            if (size > 16383) {
                throw new Exception("Not implemented yet!");
            }
            byte[] array = buffer.array();
            if (array[start] >= 0) {
                buffer.add((byte)0);
                for (int i = buffer.index() - 1; i > start; --i) {
                    array[i + 1] = array[i];
                }
                array[start] = -1;
                array[start + 1] = 0;
            }
        }
        if (updateSize) {
            int index = buffer.index();
            buffer.index_$eq(start);
            this.writeInt(buffer, index - start);
            buffer.index_$eq(index);
        }
    }

    public void writeInt(ByteBuffer buffer, int n) {
        int i = n;
        while (true) {
            if ((i & ~127) == 0) {
                buffer.add((byte)i);
                return;
            }
            buffer.add((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
    }

    public void writeInteger(ByteBuffer buffer, int n) {
        this.writeInt(buffer, n);
    }

    public void writeSeq(ByteBuffer buffer, Seq<?> seq) {
        int start = this.data(buffer);
        this.writeInt(buffer, seq.size());
        for (int i = 0; i < seq.size(); ++i) {
            Object elem = seq.apply(i);
            this.data(buffer, start, false);
        }
        this.data(buffer, start, true);
    }

    public void writeSerial(ByteBuffer buffer, Serial serial) {
        int start = buffer.index();
        boolean embedded = start > 1;
        Object object = embedded ? BoxesRunTime.boxToInteger((int)this.data(buffer)) : BoxedUnit.UNIT;
        Mirror mirror = Reflect$.MODULE$.apply(serial.getClass());
        this.writeInt(buffer, mirror.id());
        mirror.attributes().foreach((Function1)new Serializable(buffer, serial, start, embedded){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$1;
            private final Serial serial$1;
            private final int start$1;
            private final boolean embedded$1;

            public final void apply(Attribute attribute) {
                Object value = attribute.get(this.serial$1);
                if (value != null) {
                    Object object = value;
                    if (object instanceof Integer) {
                        BoxedUnit boxedUnit;
                        int n = BoxesRunTime.unboxToInt((Object)object);
                        if (n != 0) {
                            Serialize$.MODULE$.writeTypeId(this.buffer$1, Serialize$.MODULE$.INTEGER(), attribute.id());
                            Serialize$.MODULE$.writeInteger(this.buffer$1, n);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else if (object instanceof String) {
                        BoxedUnit boxedUnit;
                        String string = (String)object;
                        if (string.length() != 0) {
                            Serialize$.MODULE$.writeTypeId(this.buffer$1, Serialize$.MODULE$.STRING(), attribute.id());
                            Serialize$.MODULE$.writeString(this.buffer$1, string);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit;
                    } else if (object instanceof Serial) {
                        Serial serial = (Serial)object;
                        Serialize$.MODULE$.writeTypeId(this.buffer$1, Serialize$.MODULE$.SERIAL(), attribute.id());
                        Serialize$.MODULE$.writeSerial(this.buffer$1, serial);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (object instanceof Seq) {
                        Seq seq = (Seq)object;
                        Serialize$.MODULE$.writeTypeId(this.buffer$1, Serialize$.MODULE$.SEQ(), attribute.id());
                        Serialize$.MODULE$.writeSeq(this.buffer$1, seq);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                if (this.embedded$1) {
                    Serialize$.MODULE$.data(this.buffer$1, this.start$1, false);
                }
            }
            {
                this.buffer$1 = buffer$1;
                this.serial$1 = serial$1;
                this.start$1 = start$1;
                this.embedded$1 = embedded$1;
            }
        });
        if (embedded) {
            this.data(buffer, start, true);
        }
        buffer.add((byte)255);
    }

    public void writeString(ByteBuffer buffer, String string) {
        int i;
        int len = 0;
        int strLength = string.length();
        for (i = 0; i < strLength; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++len;
                continue;
            }
            if (c > '\u07ff') {
                len += 3;
                continue;
            }
            len += 2;
        }
        this.writeInt(buffer, len);
        for (i = 0; i < strLength; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                buffer.add((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                buffer.add((byte)(0xE0 | c >> 12 & 0xF));
                buffer.add((byte)(0x80 | c >> 6 & 0x3F));
                buffer.add((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            buffer.add((byte)(0xC0 | c >> 6 & 0x1F));
            buffer.add((byte)(0x80 | c >> 0 & 0x3F));
        }
    }

    public void writeTypeId(ByteBuffer buffer, byte tpe, int id2) {
        int id1 = id2 & 0xF;
        if (id2 <= 15 && id2 >= 0) {
            byte by = (byte)(tpe | id1);
            buffer.add(by);
            return;
        }
        byte by = (byte)(tpe | id1 | 0x10);
        buffer.add(by);
        int i = id2 >>> 4;
        while (true) {
            if ((i & ~127) == 0) {
                buffer.add((byte)i);
                return;
            }
            buffer.add((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
    }

    private Serialize$() {
        MODULE$ = this;
    }
}

