/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.event_handler;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.work.Data;
import com.optimizely.ab.android.event_handler.EventWorker;
import com.optimizely.ab.android.shared.WorkerScheduler;
import com.optimizely.ab.event.EventHandler;
import com.optimizely.ab.event.LogEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventHandler
implements EventHandler {
    @NonNull
    private final Context context;
    Logger logger = LoggerFactory.getLogger(DefaultEventHandler.class);
    private long dispatchInterval = -1L;

    private DefaultEventHandler(@NonNull Context context) {
        this.context = context;
    }

    public static DefaultEventHandler getInstance(@NonNull Context context) {
        return new DefaultEventHandler(context);
    }

    public void setDispatchInterval(long dispatchInterval) {
        this.dispatchInterval = dispatchInterval <= 0L ? -1L : dispatchInterval;
    }

    public void dispatchEvent(@NonNull LogEvent logEvent) {
        if (logEvent.getEndpointUrl() == null) {
            this.logger.error("Event dispatcher received a null url");
            return;
        }
        if (logEvent.getBody() == null) {
            this.logger.error("Event dispatcher received a null request body");
            return;
        }
        if (logEvent.getEndpointUrl().isEmpty()) {
            this.logger.error("Event dispatcher received an empty url");
        }
        WorkerScheduler.startService((Context)this.context, (String)"EventWorker", EventWorker.class, (Data)EventWorker.getData(logEvent), (Long)this.dispatchInterval);
        this.logger.info("Sent url {} to the event handler service", (Object)logEvent.getEndpointUrl());
    }
}

