/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.event_handler;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.optimizely.ab.android.event_handler.Event;
import com.optimizely.ab.android.event_handler.EventSQLiteOpenHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventDAO {
    @NonNull
    final Logger logger;
    @NonNull
    private final EventSQLiteOpenHelper dbHelper;

    private EventDAO(@NonNull EventSQLiteOpenHelper dbHelper, @NonNull Logger logger) {
        this.dbHelper = dbHelper;
        this.logger = logger;
    }

    @RequiresApi(api=11)
    static EventDAO getInstance(@NonNull Context context, @NonNull String projectId, @NonNull Logger logger) {
        EventSQLiteOpenHelper sqLiteOpenHelper = new EventSQLiteOpenHelper(context, projectId, null, 1, LoggerFactory.getLogger(EventSQLiteOpenHelper.class));
        return new EventDAO(sqLiteOpenHelper, logger);
    }

    boolean storeEvent(@NonNull Event event) {
        this.logger.info("Inserting {} into db", (Object)event);
        ContentValues values = new ContentValues();
        values.put("url", event.getURL().toString());
        values.put("requestBody", event.getRequestBody());
        try {
            long newRowId = this.dbHelper.getWritableDatabase().insert("event", null, values);
            this.logger.info("Inserted {} into db", (Object)event);
            return newRowId != -1L;
        }
        catch (Exception e) {
            this.logger.error("Error inserting Optimizely event into db.", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Pair<Long, Event>> getEvents() {
        LinkedList<Pair<Long, Event>> events = new LinkedList<Pair<Long, Event>>();
        String[] projection = new String[]{"_id", "url", "requestBody"};
        Cursor cursor = null;
        try {
            cursor = this.dbHelper.getReadableDatabase().query("event", projection, null, null, null, null, null);
            this.logger.info("Opened database");
        }
        catch (Exception e) {
            this.logger.error("Failed to open database.", (Throwable)e);
        }
        try {
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    long itemId = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
                    String url = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                    String requestBody = cursor.getString(cursor.getColumnIndexOrThrow("requestBody"));
                    try {
                        events.add((Pair<Long, Event>)new Pair((Object)itemId, (Object)new Event(new URL(url), requestBody)));
                    }
                    catch (MalformedURLException e) {
                        this.logger.error("Retrieved a malformed event from storage", (Throwable)e);
                    }
                } while (cursor.moveToNext());
                this.logger.info("Got events from SQLite");
            }
        }
        catch (Exception e) {
            this.logger.error("Error reading events db cursor", (Throwable)e);
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                try {
                    cursor.close();
                    this.logger.info("Closed database");
                }
                catch (Exception e) {
                    this.logger.error("Error closing db cursor", (Throwable)e);
                }
            }
        }
        return events;
    }

    boolean removeEvent(long eventId) {
        String selection = "_id = ?";
        String[] selectionArgs = new String[]{String.valueOf(eventId)};
        try {
            int numRowsDeleted = this.dbHelper.getWritableDatabase().delete("event", selection, selectionArgs);
            if (numRowsDeleted > 0) {
                this.logger.info("Removed event with id {} from db", (Object)eventId);
                return true;
            }
            this.logger.error("Tried to remove an event id {} that does not exist", (Object)eventId);
            return numRowsDeleted > 0;
        }
        catch (Exception e) {
            this.logger.error("Could not open db.", (Throwable)e);
            return false;
        }
    }

    void closeDb() {
        try {
            this.dbHelper.close();
        }
        catch (Exception e) {
            this.logger.warn("Error closing db.", (Throwable)e);
        }
    }
}

