/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.event_handler;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.optimizely.ab.android.event_handler.EventClient;
import com.optimizely.ab.android.event_handler.EventDAO;
import com.optimizely.ab.android.event_handler.EventDispatcher;
import com.optimizely.ab.android.shared.Client;
import com.optimizely.ab.android.shared.OptlyStorage;
import com.optimizely.ab.android.shared.ServiceScheduler;
import com.optimizely.ab.event.LogEvent;
import org.slf4j.LoggerFactory;

public class EventWorker
extends Worker {
    public static final String workerId = "EventWorker";
    EventDispatcher eventDispatcher;

    public EventWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
        OptlyStorage optlyStorage = new OptlyStorage(context);
        EventClient eventClient = new EventClient(new Client(optlyStorage, LoggerFactory.getLogger(Client.class)), LoggerFactory.getLogger(EventClient.class));
        EventDAO eventDAO = EventDAO.getInstance(context, "1", LoggerFactory.getLogger(EventDAO.class));
        ServiceScheduler serviceScheduler = new ServiceScheduler(context, new ServiceScheduler.PendingIntentFactory(context), LoggerFactory.getLogger(ServiceScheduler.class));
        this.eventDispatcher = new EventDispatcher(context, optlyStorage, eventDAO, eventClient, serviceScheduler, LoggerFactory.getLogger(EventDispatcher.class));
    }

    public static Data getData(LogEvent event) {
        return new Data.Builder().putString("url", event.getEndpointUrl()).putString("body", event.getBody()).build();
    }

    @NonNull
    public ListenableWorker.Result doWork() {
        String url = this.getInputData().getString("url");
        String body = this.getInputData().getString("body");
        boolean dispatched = true;
        dispatched = url != null && !url.isEmpty() && body != null && !body.isEmpty() ? this.eventDispatcher.dispatch(url, body) : this.eventDispatcher.dispatch();
        return dispatched ? ListenableWorker.Result.success() : ListenableWorker.Result.retry();
    }
}

