/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.event_handler;

import androidx.annotation.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.codec.binary.Base64;

public class EventHandlerUtils {
    private static final int BUFFER_SIZE = 32768;

    public static String compress(@NonNull String decompressed) throws IOException {
        byte[] data = decompressed.getBytes();
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);){
            deflater.finish();
            byte[] buffer = new byte[32768];
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            byte[] bytes = outputStream.toByteArray();
            String string = EventHandlerUtils.encodeToBase64(bytes);
            return string;
        }
    }

    public static String decompress(@NonNull String base64) throws Exception {
        byte[] data = EventHandlerUtils.decodeFromBase64(base64);
        Inflater inflater = new Inflater();
        inflater.setInput(data);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);){
            byte[] buffer = new byte[32768];
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            String string = outputStream.toString();
            return string;
        }
    }

    static String encodeToBase64(byte[] bytes) {
        String base64 = "";
        if (bytes != null) {
            byte[] encoded = Base64.encodeBase64((byte[])bytes);
            base64 = new String(encoded);
        }
        return base64;
    }

    static byte[] decodeFromBase64(String base64) {
        return Base64.decodeBase64((byte[])base64.getBytes());
    }
}

