/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.event_handler;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.optimizely.ab.android.event_handler.EventClient;
import com.optimizely.ab.android.event_handler.EventDAO;
import com.optimizely.ab.android.event_handler.EventDispatcher;
import com.optimizely.ab.android.event_handler.EventHandlerUtils;
import com.optimizely.ab.android.shared.Client;
import com.optimizely.ab.android.shared.OptlyStorage;
import com.optimizely.ab.android.shared.ServiceScheduler;
import com.optimizely.ab.event.LogEvent;
import org.slf4j.LoggerFactory;

public class EventWorker
extends Worker {
    public static final String workerId = "EventWorker";
    @VisibleForTesting
    public EventDispatcher eventDispatcher;

    public EventWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
        OptlyStorage optlyStorage = new OptlyStorage(context);
        EventClient eventClient = new EventClient(new Client(optlyStorage, LoggerFactory.getLogger(Client.class)), LoggerFactory.getLogger(EventClient.class));
        EventDAO eventDAO = EventDAO.getInstance(context, "1", LoggerFactory.getLogger(EventDAO.class));
        ServiceScheduler serviceScheduler = new ServiceScheduler(context, new ServiceScheduler.PendingIntentFactory(context), LoggerFactory.getLogger(ServiceScheduler.class));
        this.eventDispatcher = new EventDispatcher(context, optlyStorage, eventDAO, eventClient, serviceScheduler, LoggerFactory.getLogger(EventDispatcher.class));
    }

    @NonNull
    public ListenableWorker.Result doWork() {
        Data inputData = this.getInputData();
        String url = inputData.getString("url");
        String body = this.getEventBodyFromInputData(inputData);
        boolean dispatched = true;
        dispatched = this.isEventValid(url, body) ? this.eventDispatcher.dispatch(url, body) : this.eventDispatcher.dispatch();
        return dispatched ? ListenableWorker.Result.success() : ListenableWorker.Result.retry();
    }

    public static Data getData(LogEvent event) {
        String url = event.getEndpointUrl();
        String body = event.getBody();
        int maxSizeBeforeCompress = 9240;
        if (body.length() < maxSizeBeforeCompress) {
            return EventWorker.dataForEvent(url, body);
        }
        return EventWorker.compressEvent(url, body);
    }

    @VisibleForTesting
    public static Data compressEvent(String url, String body) {
        try {
            String compressed = EventHandlerUtils.compress(body);
            return EventWorker.dataForCompressedEvent(url, compressed);
        }
        catch (Exception e) {
            return EventWorker.dataForEvent(url, body);
        }
    }

    @VisibleForTesting
    public static Data dataForEvent(String url, String body) {
        return new Data.Builder().putString("url", url).putString("body", body).build();
    }

    @VisibleForTesting
    public static Data dataForCompressedEvent(String url, String compressed) {
        return new Data.Builder().putString("url", url).putString("bodyCompressed", compressed).build();
    }

    @VisibleForTesting
    @Nullable
    public String getEventBodyFromInputData(Data inputData) {
        String body = inputData.getString("body");
        if (body != null) {
            return body;
        }
        String compressed = inputData.getString("bodyCompressed");
        try {
            return EventHandlerUtils.decompress(compressed);
        }
        catch (Exception e) {
            return null;
        }
    }

    @VisibleForTesting
    public boolean isEventValid(String url, String body) {
        return url != null && !url.isEmpty() && body != null && !body.isEmpty();
    }
}

