/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.event_handler;

import com.optimizely.ab.android.event_handler.Event;
import com.optimizely.ab.android.shared.Client;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import org.slf4j.Logger;

class EventClient {
    private final Client client;
    private final Logger logger;

    EventClient(Client client, Logger logger) {
        this.client = client;
        this.logger = logger;
    }

    boolean sendEvent(final Event event) {
        Client.Request<Boolean> request = new Client.Request<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean execute() {
                HttpURLConnection urlConnection = null;
                try {
                    EventClient.this.logger.info("Dispatching event: {}", (Object)event);
                    urlConnection = EventClient.this.client.openConnection(event.getURL());
                    if (urlConnection == null) {
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    urlConnection.setRequestMethod("POST");
                    urlConnection.setRequestProperty("Content-Type", "application/json");
                    urlConnection.setDoOutput(true);
                    OutputStream outputStream = urlConnection.getOutputStream();
                    outputStream.write(event.getRequestBody().getBytes());
                    outputStream.flush();
                    outputStream.close();
                    int status = urlConnection.getResponseCode();
                    if (status >= 200 && status < 300) {
                        BufferedInputStream in = new BufferedInputStream(urlConnection.getInputStream());
                        ((InputStream)in).close();
                        EventClient.this.logger.info("Successfully dispatched event: {}", (Object)event);
                        Boolean bl = Boolean.TRUE;
                        return bl;
                    }
                    EventClient.this.logger.error("Unexpected response from event endpoint, status: " + status);
                    Boolean in = Boolean.FALSE;
                    return in;
                }
                catch (Exception e) {
                    EventClient.this.logger.error("Unable to send event: {}", (Object)event, (Object)e);
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                finally {
                    if (urlConnection != null) {
                        try {
                            urlConnection.disconnect();
                        }
                        catch (Exception e) {
                            EventClient.this.logger.error("Unable to close connection", (Throwable)e);
                        }
                    }
                }
            }
        };
        Boolean success = (Boolean)this.client.execute((Client.Request)request, 2, 5);
        if (success == null) {
            success = false;
        }
        this.logger.debug("SendEvent completed: {}", (Object)event);
        return success;
    }
}

