/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.event_handler;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.NetworkInfo;
import androidx.annotation.NonNull;
import androidx.work.Data;
import com.optimizely.ab.android.event_handler.EventIntentService;
import com.optimizely.ab.android.event_handler.EventWorker;
import com.optimizely.ab.android.shared.ServiceScheduler;
import com.optimizely.ab.android.shared.WorkerScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventRescheduler
extends BroadcastReceiver {
    Logger logger = LoggerFactory.getLogger(EventRescheduler.class);

    public void onReceive(Context context, Intent intent) {
        if (context != null && intent != null) {
            ServiceScheduler serviceScheduler = new ServiceScheduler(context, new ServiceScheduler.PendingIntentFactory(context), LoggerFactory.getLogger(ServiceScheduler.class));
            Intent eventServiceIntent = new Intent(context, EventIntentService.class);
            this.reschedule(context, intent, eventServiceIntent, serviceScheduler);
        } else {
            this.logger.warn("Received invalid broadcast to event rescheduler");
        }
    }

    void reschedule(@NonNull Context context, @NonNull Intent broadcastIntent, @NonNull Intent eventServiceIntent, @NonNull ServiceScheduler serviceScheduler) {
        if (broadcastIntent.getAction().equals("android.intent.action.BOOT_COMPLETED") || broadcastIntent.getAction().equals("android.intent.action.MY_PACKAGE_REPLACED")) {
            WorkerScheduler.startService((Context)context, (String)"EventWorker", EventWorker.class, (Data)Data.EMPTY, (Long)-1L);
            this.logger.info("Rescheduling event flushing if necessary");
        } else if (broadcastIntent.getAction().equals("android.net.wifi.WIFI_STATE_CHANGED")) {
            NetworkInfo info = (NetworkInfo)broadcastIntent.getParcelableExtra("networkInfo");
            if (info != null && info.isConnected()) {
                WorkerScheduler.startService((Context)context, (String)"EventWorker", EventWorker.class, (Data)Data.EMPTY, (Long)-1L);
                this.logger.info("Preemptively flushing events since wifi became available");
            }
        } else {
            this.logger.warn("Received unsupported broadcast action to event rescheduler");
        }
    }
}

