/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.event_handler;

import android.content.Context;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.optimizely.ab.android.event_handler.Event;
import com.optimizely.ab.android.event_handler.EventClient;
import com.optimizely.ab.android.event_handler.EventDAO;
import com.optimizely.ab.android.shared.CountingIdlingResourceManager;
import com.optimizely.ab.android.shared.OptlyStorage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;

@VisibleForTesting(otherwise=4)
public class EventDispatcher {
    @NonNull
    private final Context context;
    @NonNull
    private final EventDAO eventDAO;
    @NonNull
    private final EventClient eventClient;
    @NonNull
    private final Logger logger;
    @NonNull
    private final OptlyStorage optlyStorage;

    EventDispatcher(@NonNull Context context, @NonNull OptlyStorage optlyStorage, @NonNull EventDAO eventDAO, @NonNull EventClient eventClient, @NonNull Logger logger) {
        this.context = context;
        this.optlyStorage = optlyStorage;
        this.eventDAO = eventDAO;
        this.eventClient = eventClient;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(otherwise=4)
    public boolean dispatch(String url, String body) {
        boolean dispatched = false;
        Event event = null;
        try {
            event = new Event(new URL(url), body);
            dispatched = this.dispatch(event);
        }
        catch (MalformedURLException e) {
            this.logger.error("Received a malformed URL in event handler service", (Throwable)e);
        }
        finally {
            this.eventDAO.closeDb();
        }
        return dispatched;
    }

    protected boolean dispatch() {
        List<Pair<Long, Event>> events = this.eventDAO.getEvents();
        Iterator<Pair<Long, Event>> iterator = events.iterator();
        while (iterator.hasNext()) {
            Pair<Long, Event> event = iterator.next();
            boolean eventWasSent = this.eventClient.sendEvent((Event)event.second);
            if (!eventWasSent) continue;
            iterator.remove();
            boolean eventWasDeleted = this.eventDAO.removeEvent((Long)event.first);
            if (eventWasDeleted) continue;
            this.logger.warn("Unable to delete an event from local storage that was sent to successfully");
        }
        return events.isEmpty();
    }

    private boolean dispatch(Event event) {
        boolean eventWasSent = this.eventClient.sendEvent(event);
        if (eventWasSent) {
            CountingIdlingResourceManager.decrement();
            CountingIdlingResourceManager.recordEvent((Pair)new Pair((Object)event.getURL().toString(), (Object)event.getRequestBody()));
            return true;
        }
        boolean eventWasStored = this.eventDAO.storeEvent(event);
        if (!eventWasStored) {
            this.logger.error("Unable to send or store event {}", (Object)event);
            return true;
        }
        return false;
    }
}

