/*
 * Decompiled with CFR 0.152.
 */
package com.optimizely.ab.android.event_handler;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.optimizely.ab.android.event_handler.EventClient;
import com.optimizely.ab.android.event_handler.EventDAO;
import com.optimizely.ab.android.event_handler.EventDispatcher;
import com.optimizely.ab.android.shared.Client;
import com.optimizely.ab.android.shared.EventHandlerUtils;
import com.optimizely.ab.android.shared.OptlyStorage;
import com.optimizely.ab.event.LogEvent;
import org.slf4j.LoggerFactory;

public class EventWorker
extends Worker {
    public static final String workerId = "EventWorker";
    public static final String KEY_EVENT_URL = "url";
    public static final String KEY_EVENT_BODY = "body";
    public static final String KEY_EVENT_BODY_COMPRESSED = "bodyCompressed";
    public static final String KEY_EVENT_RETRY_INTERVAL = "retryInterval";
    @VisibleForTesting
    public EventDispatcher eventDispatcher;

    public EventWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
        super(context, workerParams);
        OptlyStorage optlyStorage = new OptlyStorage(context);
        EventClient eventClient = new EventClient(new Client(optlyStorage, LoggerFactory.getLogger(Client.class)), LoggerFactory.getLogger(EventClient.class));
        EventDAO eventDAO = EventDAO.getInstance(context, "1", LoggerFactory.getLogger(EventDAO.class));
        this.eventDispatcher = new EventDispatcher(context, optlyStorage, eventDAO, eventClient, LoggerFactory.getLogger(EventDispatcher.class));
    }

    @NonNull
    public ListenableWorker.Result doWork() {
        Data inputData = this.getInputData();
        String url = this.getUrlFromInputData(inputData);
        String body = this.getEventBodyFromInputData(inputData);
        long interval = this.getRetryIntervalFromInputData(inputData);
        boolean dispatched = true;
        dispatched = this.isEventValid(url, body) ? this.eventDispatcher.dispatch(url, body) : this.eventDispatcher.dispatch();
        if (interval > 0L) {
            return dispatched ? ListenableWorker.Result.success() : ListenableWorker.Result.retry();
        }
        return ListenableWorker.Result.success();
    }

    public static Data getData(LogEvent event) {
        String url = event.getEndpointUrl();
        String body = event.getBody();
        int maxSizeBeforeCompress = 9240;
        if (body.length() < maxSizeBeforeCompress) {
            return EventWorker.dataForEvent(url, body);
        }
        return EventWorker.compressEvent(url, body);
    }

    @VisibleForTesting
    public static Data getData(LogEvent event, Long retryInterval) {
        Data data = EventWorker.getData(event);
        if (retryInterval > 0L) {
            data = new Data.Builder().putAll(data).putLong(KEY_EVENT_RETRY_INTERVAL, retryInterval.longValue()).build();
        }
        return data;
    }

    @VisibleForTesting
    public static Data compressEvent(String url, String body) {
        try {
            String compressed = EventHandlerUtils.compress((String)body);
            return EventWorker.dataForCompressedEvent(url, compressed);
        }
        catch (Exception e) {
            return EventWorker.dataForEvent(url, body);
        }
    }

    @VisibleForTesting
    public static Data dataForEvent(String url, String body) {
        return new Data.Builder().putString(KEY_EVENT_URL, url).putString(KEY_EVENT_BODY, body).build();
    }

    @VisibleForTesting
    public static Data dataForCompressedEvent(String url, String compressed) {
        return new Data.Builder().putString(KEY_EVENT_URL, url).putString(KEY_EVENT_BODY_COMPRESSED, compressed).build();
    }

    @VisibleForTesting
    @Nullable
    public String getEventBodyFromInputData(Data inputData) {
        String body = inputData.getString(KEY_EVENT_BODY);
        if (body != null) {
            return body;
        }
        String compressed = inputData.getString(KEY_EVENT_BODY_COMPRESSED);
        try {
            return EventHandlerUtils.decompress((String)compressed);
        }
        catch (Exception e) {
            return null;
        }
    }

    @VisibleForTesting
    public String getUrlFromInputData(Data data) {
        return data.getString(KEY_EVENT_URL);
    }

    @VisibleForTesting
    public long getRetryIntervalFromInputData(Data data) {
        return data.getLong(KEY_EVENT_RETRY_INTERVAL, -1L);
    }

    @VisibleForTesting
    public boolean isEventValid(String url, String body) {
        return url != null && !url.isEmpty() && body != null && !body.isEmpty();
    }
}

