/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.extensible.AbstractExtensible;
import com.oracle.bedrock.options.Diagnostics;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationConsole;
import com.oracle.bedrock.runtime.ApplicationConsoleBuilder;
import com.oracle.bedrock.runtime.ApplicationListener;
import com.oracle.bedrock.runtime.ApplicationProcess;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.console.SystemApplicationConsole;
import com.oracle.bedrock.runtime.java.container.Container;
import com.oracle.bedrock.runtime.options.ApplicationClosingBehavior;
import com.oracle.bedrock.runtime.options.Console;
import com.oracle.bedrock.runtime.options.DisplayName;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicBoolean;

@Internal
public abstract class AbstractApplication<P extends ApplicationProcess>
extends AbstractExtensible
implements Application {
    protected final Platform platform;
    protected final String displayName;
    protected final P process;
    protected final OptionsByType optionsByType;
    protected final ApplicationConsole console;
    private final Thread stdoutThread;
    private final Thread stderrThread;
    private final Thread stdinThread;
    private Timeout defaultTimeout;
    private AtomicBoolean closed;

    public AbstractApplication(Platform platform, P process, OptionsByType optionsByType) {
        this.platform = platform;
        this.process = process;
        this.optionsByType = optionsByType;
        this.closed = new AtomicBoolean(false);
        this.defaultTimeout = (Timeout)optionsByType.get(Timeout.class, new Object[0]);
        boolean diagnosticsEnabled = ((Diagnostics)optionsByType.get(Diagnostics.class, new Object[0])).isEnabled();
        this.displayName = ((DisplayName)optionsByType.get(DisplayName.class, new Object[0])).resolve(optionsByType);
        this.console = ((ApplicationConsoleBuilder)optionsByType.getOrSetDefault(ApplicationConsoleBuilder.class, (Option)Console.system())).build(this.displayName);
        this.stdoutThread = new Thread(new OutputRedirector(this.displayName, "out", process.getInputStream(), this.console.getOutputWriter(), process.getId(), diagnosticsEnabled && !(this.console instanceof SystemApplicationConsole), this.console.isDiagnosticsEnabled()));
        this.stdoutThread.setDaemon(true);
        this.stdoutThread.setName(this.displayName + " StdOut Thread");
        this.stdoutThread.start();
        this.stderrThread = new Thread(new OutputRedirector(this.displayName, "err", process.getErrorStream(), this.console.getErrorWriter(), process.getId(), diagnosticsEnabled && !(this.console instanceof SystemApplicationConsole), this.console.isDiagnosticsEnabled()));
        this.stderrThread.setDaemon(true);
        this.stderrThread.setName(this.displayName + " StdErr Thread");
        this.stderrThread.start();
        this.stdinThread = new Thread(new InputRedirector(this.console.getInputReader(), process.getOutputStream()));
        this.stdinThread.setDaemon(true);
        this.stdinThread.setName(this.displayName + " StdIn Thread");
        this.stdinThread.start();
    }

    @Override
    public Timeout getDefaultTimeout() {
        return this.defaultTimeout;
    }

    @Override
    public String getName() {
        return this.displayName;
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public OptionsByType getOptions() {
        return this.optionsByType;
    }

    @Override
    public boolean isOperational() {
        return !this.closed.get();
    }

    @Override
    public void close() {
        this.close(new Option[0]);
    }

    @Override
    public void close(Option ... options) {
        if (this.closed.compareAndSet(false, true)) {
            OptionsByType closingOptions = OptionsByType.of((Option[])options);
            for (ApplicationListener listener : this.getInstancesOf(ApplicationListener.class)) {
                listener.onClosing(this, closingOptions);
            }
            for (Profile profile : this.getOptions().getInstancesOf(Profile.class)) {
                profile.onClosing(this.platform, this, this.getOptions());
            }
            for (ApplicationListener listener : this.getOptions().getInstancesOf(ApplicationListener.class)) {
                listener.onClosing(this, closingOptions);
            }
            ApplicationClosingBehavior defaultClosingBehavior = (ApplicationClosingBehavior)this.getOptions().get(ApplicationClosingBehavior.class, new Object[0]);
            ApplicationClosingBehavior closingBehavior = (ApplicationClosingBehavior)closingOptions.getOrDefault(ApplicationClosingBehavior.class, (Option)defaultClosingBehavior);
            if (closingBehavior != null) {
                try {
                    closingBehavior.onBeforeClosing(this, options);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.process.close();
            try {
                this.stdinThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.stdoutThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.stdoutThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.stderrThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.stderrThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.console.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.waitFor(options);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            for (ApplicationListener listener : this.getOptions().getInstancesOf(ApplicationListener.class)) {
                listener.onClosed(this, closingOptions);
            }
            for (ApplicationListener listener : this.getInstancesOf(ApplicationListener.class)) {
                listener.onClosed(this, closingOptions);
            }
            this.removeAllFeatures();
        }
    }

    @Override
    public long getId() {
        return this.process.getId();
    }

    @Override
    public int waitFor(Option ... options) {
        OptionsByType waitForOptions = OptionsByType.of((Option[])this.getOptions().asArray()).addAll(options);
        return this.process.waitFor(waitForOptions.asArray());
    }

    @Override
    public int exitValue() {
        return this.process.exitValue();
    }

    static class OutputRedirector
    implements Runnable {
        private String applicationName;
        private String prefix;
        private long processId;
        private boolean diagnosticsEnabled;
        private InputStream inputStream;
        private PrintWriter printWriter;
        private boolean consoleDiagnosticsEnabled;

        OutputRedirector(String applicationName, String prefix, InputStream inputStream, PrintWriter printWriter, long processId, boolean diagnosticsEnabled, boolean consoleDiagnosticsEnabled) {
            this.applicationName = applicationName;
            this.prefix = prefix;
            this.inputStream = inputStream;
            this.printWriter = printWriter;
            this.processId = processId;
            this.diagnosticsEnabled = diagnosticsEnabled;
            this.consoleDiagnosticsEnabled = consoleDiagnosticsEnabled;
        }

        @Override
        public void run() {
            long lineNumber = 1L;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(this.inputStream)));
                boolean running = true;
                while (running || reader.ready()) {
                    try {
                        String line = reader.readLine();
                        if (line != null) {
                            String output;
                            String diagnosticOutput = this.diagnosticsEnabled || this.consoleDiagnosticsEnabled ? String.format("[%s:%s%s] %4d: %s", this.applicationName, this.prefix, this.processId < 0L ? "" : ":" + this.processId, lineNumber++, line) : null;
                            String string = output = this.consoleDiagnosticsEnabled ? diagnosticOutput : line;
                            if (this.diagnosticsEnabled) {
                                Container.getPlatformScope().getStandardOutput().println(output);
                            }
                            this.printWriter.println(output);
                            this.printWriter.flush();
                        }
                        break;
                    }
                    catch (InterruptedIOException e) {
                        running = false;
                    }
                }
            }
            catch (Exception reader) {
                // empty catch block
            }
            try {
                String output;
                String diagnosticOutput = this.diagnosticsEnabled || this.consoleDiagnosticsEnabled ? String.format("[%s:%s%s] %4d: (terminated)", this.applicationName, this.prefix, this.processId < 0L ? "" : ":" + this.processId, lineNumber) : null;
                String string = output = this.consoleDiagnosticsEnabled ? diagnosticOutput : "(terminated)";
                if (this.diagnosticsEnabled) {
                    Container.getPlatformScope().getStandardOutput().println(output);
                }
                this.printWriter.println(output);
                this.printWriter.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class InputRedirector
    implements Runnable {
        private Reader reader;
        private OutputStream outputStream;

        private InputRedirector(Reader reader, OutputStream outputStream) {
            this.reader = reader;
            this.outputStream = outputStream;
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader bufferedReader = new BufferedReader(this.reader);
                PrintWriter printWriter = new PrintWriter(this.outputStream);
                while ((line = bufferedReader.readLine()) != null) {
                    printWriter.println(line);
                    printWriter.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

