/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.Infrastructure;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.OperatingSystem;
import com.oracle.bedrock.runtime.options.Executable;
import com.oracle.bedrock.runtime.options.PlatformPredicate;
import java.net.InetAddress;

public interface Platform
extends Infrastructure {
    public String getName();

    public OperatingSystem getOperatingSystem();

    public InetAddress getAddress();

    public OptionsByType getOptions();

    @Override
    default public Platform getPlatform(Option ... options) {
        OptionsByType platformOptions = OptionsByType.of((Option[])options);
        PlatformPredicate predicate = (PlatformPredicate)platformOptions.get(PlatformPredicate.class, new Object[0]);
        return predicate.test(this) ? this : null;
    }

    default public Application launch(String executable, Option ... options) {
        OptionsByType optionsByType = OptionsByType.of((Option[])options).add((Option)Executable.named(executable));
        return this.launch(Application.class, optionsByType.asArray());
    }

    default public <A extends Application> A launch(Class<A> applicationClass, Option ... options) {
        MetaClass metaClass = MetaClass.of(applicationClass);
        if (metaClass == null) {
            throw new IllegalArgumentException("The specified application class " + applicationClass + ", the interfaces it implements and its super-class does not define a public non-static MetaClass");
        }
        return this.launch(metaClass, options);
    }

    public <A extends Application> A launch(MetaClass<A> var1, Option ... var2);

    public static PlatformPredicate any() {
        return platform -> true;
    }

    public static PlatformPredicate named(String regularExpression) {
        return PlatformPredicate.named(regularExpression);
    }

    public static PlatformPredicate is(Platform platform) {
        return PlatformPredicate.is(platform);
    }
}

