/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.deferred.Deferred;
import com.oracle.bedrock.deferred.DeferredHelper;
import com.oracle.bedrock.deferred.DeferredPredicate;
import com.oracle.bedrock.predicate.Predicates;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationListener;
import com.oracle.bedrock.runtime.ApplicationStream;
import com.oracle.bedrock.runtime.Assembly;
import com.oracle.bedrock.runtime.Infrastructure;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.options.Discriminator;
import com.oracle.bedrock.runtime.options.DisplayName;
import com.oracle.bedrock.runtime.options.StabilityPredicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
public abstract class AbstractAssembly<A extends Application>
implements Assembly<A>,
ApplicationListener<A>,
ApplicationStream<A> {
    protected CopyOnWriteArrayList<A> applications = new CopyOnWriteArrayList();
    protected AtomicBoolean isClosed = new AtomicBoolean(false);
    protected ConcurrentHashMap<DisplayName, AtomicInteger> discriminators = new ConcurrentHashMap();
    protected OptionsByType optionsByType;

    public AbstractAssembly(OptionsByType optionsByType) {
        this.optionsByType = OptionsByType.of((OptionsByType)optionsByType);
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public A get(String pattern) {
        for (Application application : this.applications) {
            if (!application.getName().matches(pattern)) continue;
            return (A)application;
        }
        return null;
    }

    public Iterable<A> getAll(String pattern) {
        LinkedList<Application> list = new LinkedList<Application>();
        for (Application application : this.applications) {
            String name = application.getName();
            if (!name.startsWith(pattern) && !name.matches(pattern)) continue;
            list.add(application);
        }
        return list;
    }

    public Iterable<A> getAll(Predicate<? super A> predicate) {
        LinkedList<Application> list = new LinkedList<Application>();
        for (Application application : this.applications) {
            if (!predicate.test(application)) continue;
            list.add(application);
        }
        return list;
    }

    public void add(A application) {
        if (this.isClosed()) {
            throw new IllegalStateException("Can't add [" + application + "] as the " + this.getClass().getName() + " is closed");
        }
        if (this.get(application.getName()) == null) {
            application.add(Assembly.class, (Object)this);
            this.applications.add(application);
            this.onExpanded(Collections.singletonList(application), application.getOptions());
        }
    }

    public boolean remove(A application) {
        if (this.isClosed()) {
            throw new IllegalStateException("Can't remove [" + application + "] as the " + this.getClass().getName() + " is closed");
        }
        application.remove(Assembly.class);
        return this.applications.remove(application);
    }

    public void expand(int count, Platform platform, Class<? extends A> applicationClass, Option ... options) {
        this.expand(count, Infrastructure.of(platform), applicationClass, options);
    }

    public void expand(int count, Infrastructure infrastructure, Class<? extends A> applicationClass, Option ... options) {
        ArrayList<A> launchedApplications = new ArrayList<A>();
        OptionsByType expandingOptions = OptionsByType.of((OptionsByType)this.optionsByType).addAll(options);
        for (int i = 0; i < count; ++i) {
            OptionsByType launchOptions = OptionsByType.of((OptionsByType)expandingOptions);
            DisplayName displayName = (DisplayName)launchOptions.getOrDefault(DisplayName.class, null);
            if (displayName != null && !launchOptions.contains(Discriminator.class)) {
                AtomicInteger counter = this.discriminators.computeIfAbsent(displayName, name -> new AtomicInteger(0));
                launchOptions.addIfAbsent((Option)Discriminator.of(counter.incrementAndGet()));
            }
            try {
                Platform platform = infrastructure.getPlatform(launchOptions.asArray());
                A application = platform.launch(applicationClass, launchOptions.asArray());
                launchedApplications.add(application);
                continue;
            }
            catch (Throwable throwable) {
                for (Application application : launchedApplications) {
                    try {
                        application.close();
                    }
                    catch (Throwable throwable2) {}
                }
                throw new RuntimeException("Failed to launch one of the desired " + applicationClass.getSimpleName() + "(s) out of " + count + " requested. Automatically closed " + launchedApplications.size() + " that were successfully created.  The options provided where " + launchOptions, throwable);
            }
        }
        for (Application application : launchedApplications) {
            application.add(Assembly.class, this);
            this.applications.add(application);
        }
        this.onExpanded(launchedApplications, expandingOptions);
    }

    protected void onExpanded(List<? extends A> applications, OptionsByType optionsByType) {
        this.onChanged(optionsByType);
    }

    protected void onRelaunching(A application, OptionsByType optionsByType) {
    }

    protected void onRelaunching(Platform platform, OptionsByType optionsByType) {
        this.onChanged(optionsByType);
    }

    protected void onRelaunched(A original, A restarted, OptionsByType optionsByType) {
        this.onChanged(optionsByType);
    }

    protected void onChanged(OptionsByType optionsByType) {
        StabilityPredicate stabilityPredicate = (StabilityPredicate)optionsByType.getOrDefault(StabilityPredicate.class, null);
        if (stabilityPredicate != null) {
            DeferredPredicate deferredPredicate = new DeferredPredicate((Object)this, stabilityPredicate.get());
            DeferredHelper.ensure((Deferred)DeferredHelper.eventually((Deferred)deferredPredicate), (Predicate)Predicates.is((Object)true));
        }
    }

    protected void relaunch(List<? extends A> applications, Option ... options) {
        applications.forEach((? super T application) -> {
            if (this.remove(application)) {
                Platform platform = application.getPlatform();
                OptionsByType applicationOptions = application.getOptions();
                OptionsByType launchOptions = OptionsByType.of((OptionsByType)applicationOptions).addAll(options);
                this.onRelaunching(application, launchOptions);
                application.close(options);
                application.waitFor(new Option[0]);
                this.onRelaunching(platform, launchOptions);
                Class<?> applicationClass = application.getClass();
                Object relaunchedApplication = platform.launch(applicationClass, launchOptions.asArray());
                this.onRelaunched(application, relaunchedApplication, launchOptions);
                this.add(relaunchedApplication);
            }
        });
    }

    protected void clone(List<? extends A> applications, int count, Option ... options) {
        OptionsByType optionsByType = OptionsByType.of((Option[])options);
        boolean definesCustomDiscriminator = optionsByType.contains(Discriminator.class);
        applications.forEach((? super T application) -> {
            Platform platform = application.getPlatform();
            OptionsByType launchOptions = OptionsByType.of((OptionsByType)application.getOptions()).addAll(options);
            if (!definesCustomDiscriminator) {
                launchOptions.remove(Discriminator.class);
            }
            Class<?> applicationClass = application.getClass();
            this.expand(count, platform, applicationClass, launchOptions.asArray());
        });
    }

    @Override
    public Iterator<A> iterator() {
        return this.applications.iterator();
    }

    @Override
    public void close() {
        this.close(new Option[0]);
    }

    @Override
    public void close(Option ... options) {
        if (this.isClosed.compareAndSet(false, true)) {
            for (Application application : this.applications) {
                if (application == null) continue;
                application.remove(Assembly.class);
                try {
                    application.close(options);
                }
                catch (Exception exception) {}
            }
            this.applications.clear();
        }
    }

    @Override
    public void onClosing(A application, OptionsByType optionsByType) {
        if (!this.isClosed()) {
            this.applications.remove(application);
        }
    }

    @Override
    public void onClosed(A application, OptionsByType optionsByType) {
    }

    @Override
    public void onLaunched(A application) {
    }

    public ApplicationStream<A> stream() {
        return new StreamAdapter(this.applications.stream());
    }

    @Override
    public void forEach(Consumer<? super A> action) {
        this.stream().forEach(action);
    }

    @Override
    public long count() {
        return this.applications.size();
    }

    @Override
    public ApplicationStream<A> filter(Predicate<? super A> predicate) {
        return this.stream().filter(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super A> predicate) {
        return this.stream().allMatch(predicate);
    }

    @Override
    public boolean anyMatch(Predicate<? super A> predicate) {
        return this.stream().anyMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super A> predicate) {
        return this.stream().noneMatch(predicate);
    }

    @Override
    public ApplicationStream<A> limit(int maximum) {
        return this.stream().limit(maximum);
    }

    @Override
    public ApplicationStream<A> peek(Consumer<? super A> consumer) {
        return this.stream().peek(consumer);
    }

    @Override
    public <R, T> R collect(Collector<? super A, T, R> collector) {
        return this.stream().collect(collector);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super A> accumulator, BiConsumer<R, R> combiner) {
        return this.stream().collect(supplier, accumulator, combiner);
    }

    @Override
    public Optional<A> findAny() {
        return this.stream().findAny();
    }

    @Override
    public Optional<A> findFirst() {
        return this.stream().findFirst();
    }

    @Override
    public ApplicationStream<A> unordered() {
        return this.stream().unordered();
    }

    @Override
    public void relaunch(Option ... options) {
        this.stream().relaunch(options);
    }

    @Override
    public void clone(int count, Option ... options) {
        this.stream().clone(count, options);
    }

    private class StreamAdapter
    implements ApplicationStream<A> {
        private Stream<A> stream;

        StreamAdapter(Stream<A> stream) {
            this.stream = stream;
        }

        @Override
        public void close(Option ... options) {
            this.stream.forEach((? super T a) -> a.close(options));
        }

        @Override
        public void forEach(Consumer<? super A> consumer) {
            this.stream.forEach(consumer);
        }

        @Override
        public long count() {
            return this.stream.count();
        }

        @Override
        public ApplicationStream<A> filter(Predicate<? super A> predicate) {
            return new StreamAdapter(this.stream.filter(predicate));
        }

        @Override
        public boolean allMatch(Predicate<? super A> predicate) {
            return this.stream.allMatch(predicate);
        }

        @Override
        public boolean anyMatch(Predicate<? super A> predicate) {
            return this.stream.anyMatch(predicate);
        }

        @Override
        public boolean noneMatch(Predicate<? super A> predicate) {
            return this.stream.noneMatch(predicate);
        }

        @Override
        public ApplicationStream<A> limit(int maximum) {
            return new StreamAdapter(this.stream.limit(maximum));
        }

        @Override
        public ApplicationStream<A> peek(Consumer<? super A> consumer) {
            return new StreamAdapter(this.stream.peek(consumer));
        }

        @Override
        public <R, T> R collect(Collector<? super A, T, R> collector) {
            return this.stream.collect(collector);
        }

        @Override
        public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super A> accumulator, BiConsumer<R, R> combiner) {
            return this.stream.collect(supplier, accumulator, combiner);
        }

        @Override
        public Optional<A> findAny() {
            return this.stream.findAny();
        }

        @Override
        public Optional<A> findFirst() {
            return this.stream.findFirst();
        }

        @Override
        public ApplicationStream<A> unordered() {
            List applications = this.stream.collect(Collectors.toList());
            Collections.shuffle(applications);
            return new StreamAdapter(applications.stream());
        }

        @Override
        public void relaunch(Option ... options) {
            List applications = this.stream.collect(Collectors.toList());
            AbstractAssembly.this.relaunch(applications, options);
        }

        @Override
        public void clone(int count, Option ... options) {
            List applications = this.stream.collect(Collectors.toList());
            AbstractAssembly.this.clone(applications, count, options);
        }
    }
}

