/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.util.Pair;
import com.oracle.bedrock.util.Version;
import java.io.File;
import java.util.LinkedHashMap;

public class OperatingSystem
implements Option {
    private static final LinkedHashMap<String, Pair<Type, String>> MAPPINGS = new LinkedHashMap();
    private final String name;
    private final String releaseName;
    private final Type type;
    private final Version version;
    private final String fileSeparator;
    private final String pathSeparator;
    private final String lineSeparator;

    private OperatingSystem(String name, String releaseName, Type type, Version version, String fileSeparator, String pathSeparator, String lineSeparator) {
        this.name = name;
        this.releaseName = releaseName;
        this.type = type;
        this.version = version;
        this.fileSeparator = fileSeparator;
        this.pathSeparator = pathSeparator;
        this.lineSeparator = lineSeparator;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public String toString() {
        return (Object)((Object)this.type) + " " + this.version + " (" + this.name + (this.releaseName.isEmpty() ? "" : ", " + this.releaseName) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OperatingSystem)) {
            return false;
        }
        OperatingSystem that = (OperatingSystem)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.releaseName.equals(that.releaseName)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (!this.version.equals((Object)that.version)) {
            return false;
        }
        if (!this.fileSeparator.equals(that.fileSeparator)) {
            return false;
        }
        if (!this.pathSeparator.equals(that.pathSeparator)) {
            return false;
        }
        return this.lineSeparator.equals(that.lineSeparator);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.releaseName.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.fileSeparator.hashCode();
        result = 31 * result + this.pathSeparator.hashCode();
        result = 31 * result + this.lineSeparator.hashCode();
        return result;
    }

    public static OperatingSystem custom(String name, String releaseName, Type type, Version version) {
        return new OperatingSystem(name, releaseName, type, version, type.getTypicalFileSeparator(), type.getTypicalPathSeparator(), type.getTypicalLineSeparator());
    }

    public static OperatingSystem custom(String name, String releaseName, Type type, Version version, String fileSeparator, String pathSeparator, String lineSeparator) {
        return new OperatingSystem(name, releaseName, type, version, fileSeparator, pathSeparator, lineSeparator);
    }

    @OptionsByType.Default
    public static OperatingSystem local() {
        try {
            return OperatingSystem.from(System.getProperty("os.name"), System.getProperty("os.version"));
        }
        catch (Exception e) {
            return OperatingSystem.unknown();
        }
    }

    public static OperatingSystem from(String osName, String osVersion) {
        osName = osName == null ? "" : osName.trim();
        osVersion = osVersion == null ? "" : osVersion.trim();
        String name = osName.trim().toLowerCase() + (osVersion.isEmpty() ? "" : " " + osVersion);
        Type type = Type.UNKNOWN;
        String release = "";
        for (String mapping : MAPPINGS.keySet()) {
            if (!name.matches(mapping) && !name.startsWith(mapping)) continue;
            Pair<Type, String> pair = MAPPINGS.get(mapping);
            type = (Type)((Object)pair.getX());
            release = (String)pair.getY();
            break;
        }
        return OperatingSystem.custom(osName, release, type, Version.of((String[])new String[]{osVersion}), type.getTypicalFileSeparator(), type.getTypicalPathSeparator(), type.getTypicalLineSeparator());
    }

    public static OperatingSystem unknown() {
        return OperatingSystem.custom("", "", Type.UNKNOWN, Version.of((String[])new String[]{""}), File.separator, File.pathSeparator, System.lineSeparator());
    }

    static {
        MAPPINGS.put("windows 2000", (Pair<Type, String>)Pair.of((Object)((Object)Type.WINDOWS), (Object)"2000"));
        MAPPINGS.put("windows 2003", (Pair<Type, String>)Pair.of((Object)((Object)Type.WINDOWS), (Object)"2003"));
        MAPPINGS.put("windows 2008", (Pair<Type, String>)Pair.of((Object)((Object)Type.WINDOWS), (Object)"2008"));
        MAPPINGS.put("windows server 2008", (Pair<Type, String>)Pair.of((Object)((Object)Type.WINDOWS), (Object)"Server 2008"));
        MAPPINGS.put("windows server 2012", (Pair<Type, String>)Pair.of((Object)((Object)Type.WINDOWS), (Object)"Server 2012"));
        MAPPINGS.put("windows 95", (Pair<Type, String>)Pair.of((Object)((Object)Type.WINDOWS), (Object)"95"));
        MAPPINGS.put("windows 98", (Pair<Type, String>)Pair.of((Object)((Object)Type.WINDOWS), (Object)"98"));
        MAPPINGS.put("windows me", (Pair<Type, String>)Pair.of((Object)((Object)Type.WINDOWS), (Object)"ME"));
        MAPPINGS.put("windows nt", (Pair<Type, String>)Pair.of((Object)((Object)Type.WINDOWS), (Object)"NT"));
        MAPPINGS.put("windows xp", (Pair<Type, String>)Pair.of((Object)((Object)Type.WINDOWS), (Object)"XP"));
        MAPPINGS.put("windows vista", (Pair<Type, String>)Pair.of((Object)((Object)Type.WINDOWS), (Object)"Vista"));
        MAPPINGS.put("windows 7", (Pair<Type, String>)Pair.of((Object)((Object)Type.WINDOWS), (Object)"7"));
        MAPPINGS.put("windows 8", (Pair<Type, String>)Pair.of((Object)((Object)Type.WINDOWS), (Object)"8"));
        MAPPINGS.put("windows 8.1", (Pair<Type, String>)Pair.of((Object)((Object)Type.WINDOWS), (Object)"8.1"));
        MAPPINGS.put("windows 10", (Pair<Type, String>)Pair.of((Object)((Object)Type.WINDOWS), (Object)"10"));
        MAPPINGS.put("windows", (Pair<Type, String>)Pair.of((Object)((Object)Type.WINDOWS), (Object)""));
        MAPPINGS.put("aix", (Pair<Type, String>)Pair.of((Object)((Object)Type.AIX), (Object)""));
        MAPPINGS.put("hp-ux", (Pair<Type, String>)Pair.of((Object)((Object)Type.HPUX), (Object)""));
        MAPPINGS.put("os/2", (Pair<Type, String>)Pair.of((Object)((Object)Type.OS2), (Object)""));
        MAPPINGS.put("os/400", (Pair<Type, String>)Pair.of((Object)((Object)Type.OS400), (Object)""));
        MAPPINGS.put("irix", (Pair<Type, String>)Pair.of((Object)((Object)Type.IRIX), (Object)""));
        MAPPINGS.put("linux", (Pair<Type, String>)Pair.of((Object)((Object)Type.LINUX), (Object)""));
        MAPPINGS.put("freebsd", (Pair<Type, String>)Pair.of((Object)((Object)Type.FREEBSD), (Object)""));
        MAPPINGS.put("openbsd", (Pair<Type, String>)Pair.of((Object)((Object)Type.OPENBSD), (Object)""));
        MAPPINGS.put("netbsd", (Pair<Type, String>)Pair.of((Object)((Object)Type.NETBSD), (Object)""));
        MAPPINGS.put("solaris", (Pair<Type, String>)Pair.of((Object)((Object)Type.SOLARIS), (Object)""));
        MAPPINGS.put("sunos", (Pair<Type, String>)Pair.of((Object)((Object)Type.SUNOS), (Object)""));
        MAPPINGS.put("mac os x 10.13", (Pair<Type, String>)Pair.of((Object)((Object)Type.MACOS), (Object)"High Sierra"));
        MAPPINGS.put("mac os x 10.12", (Pair<Type, String>)Pair.of((Object)((Object)Type.MACOS), (Object)"Sierra"));
        MAPPINGS.put("mac os x 10.11", (Pair<Type, String>)Pair.of((Object)((Object)Type.MACOS), (Object)"El Capitan"));
        MAPPINGS.put("mac os x 10.10", (Pair<Type, String>)Pair.of((Object)((Object)Type.MACOS), (Object)"Yosemite"));
        MAPPINGS.put("mac os x 10.9", (Pair<Type, String>)Pair.of((Object)((Object)Type.MACOS), (Object)"Mavericks"));
        MAPPINGS.put("mac os x 10.8", (Pair<Type, String>)Pair.of((Object)((Object)Type.MACOS), (Object)"Mountain Lion"));
        MAPPINGS.put("mac os x 10.7", (Pair<Type, String>)Pair.of((Object)((Object)Type.MACOS), (Object)"Lion"));
        MAPPINGS.put("mac os x 10.6", (Pair<Type, String>)Pair.of((Object)((Object)Type.MACOS), (Object)"Snow Leopard"));
        MAPPINGS.put("mac os x 10.5", (Pair<Type, String>)Pair.of((Object)((Object)Type.MACOS), (Object)"Leopard"));
        MAPPINGS.put("mac os x 10.4", (Pair<Type, String>)Pair.of((Object)((Object)Type.MACOS), (Object)"Tiger"));
        MAPPINGS.put("mac os x 10.3", (Pair<Type, String>)Pair.of((Object)((Object)Type.MACOS), (Object)"Panther"));
        MAPPINGS.put("mac os x 10.2", (Pair<Type, String>)Pair.of((Object)((Object)Type.MACOS), (Object)"Jaguar"));
        MAPPINGS.put("mac os x 10.1", (Pair<Type, String>)Pair.of((Object)((Object)Type.MACOS), (Object)"Puma"));
        MAPPINGS.put("mac os x 10.0", (Pair<Type, String>)Pair.of((Object)((Object)Type.MACOS), (Object)"Cheetah"));
        MAPPINGS.put("mac os x", (Pair<Type, String>)Pair.of((Object)((Object)Type.MACOS), (Object)""));
        MAPPINGS.put("", (Pair<Type, String>)Pair.of((Object)((Object)Type.UNKNOWN), (Object)""));
    }

    public static enum Type {
        AIX,
        FREEBSD,
        HPUX,
        IRIX,
        LINUX,
        MACOS,
        NETBSD,
        OPENBSD,
        OS2,
        OS400,
        SOLARIS,
        SUNOS,
        WINDOWS,
        ZOS,
        UNKNOWN;


        public boolean isUnix() {
            return this == AIX || this == FREEBSD || this == HPUX || this == IRIX || this == LINUX || this == MACOS || this == NETBSD || this == OPENBSD || this == SOLARIS || this == SUNOS || this == ZOS;
        }

        public boolean isWindows() {
            return this == WINDOWS;
        }

        public boolean isBSD() {
            return this == FREEBSD || this == MACOS || this == NETBSD || this == OPENBSD;
        }

        String getTypicalFileSeparator() {
            return this.isWindows() ? "\\" : (this.isUnix() || this.isBSD() ? "/" : File.separator);
        }

        String getTypicalPathSeparator() {
            return this.isWindows() ? ";" : (this.isUnix() || this.isBSD() ? ":" : File.pathSeparator);
        }

        String getTypicalLineSeparator() {
            return this.isWindows() ? "\r\n" : (this.isUnix() || this.isBSD() ? "\n" : System.lineSeparator());
        }
    }
}

