/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java;

import com.oracle.bedrock.Bedrock;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.deferred.AbstractDeferred;
import com.oracle.bedrock.deferred.Deferred;
import com.oracle.bedrock.deferred.DeferredHelper;
import com.oracle.bedrock.deferred.PermanentlyUnavailableException;
import com.oracle.bedrock.deferred.TemporarilyUnavailableException;
import com.oracle.bedrock.lang.ExpressionEvaluator;
import com.oracle.bedrock.lang.StringHelper;
import com.oracle.bedrock.options.LaunchLogging;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.options.Variable;
import com.oracle.bedrock.options.Variables;
import com.oracle.bedrock.runtime.ApplicationListener;
import com.oracle.bedrock.runtime.LocalApplicationProcess;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.Profiles;
import com.oracle.bedrock.runtime.concurrent.ControllableRemoteChannel;
import com.oracle.bedrock.runtime.concurrent.RemoteCallable;
import com.oracle.bedrock.runtime.concurrent.RemoteEvent;
import com.oracle.bedrock.runtime.concurrent.RemoteEventListener;
import com.oracle.bedrock.runtime.concurrent.RemoteRunnable;
import com.oracle.bedrock.runtime.concurrent.socket.SocketBasedRemoteChannelServer;
import com.oracle.bedrock.runtime.java.ClassPath;
import com.oracle.bedrock.runtime.java.JavaApplication;
import com.oracle.bedrock.runtime.java.JavaApplicationLauncher;
import com.oracle.bedrock.runtime.java.JavaApplicationProcess;
import com.oracle.bedrock.runtime.java.JavaApplicationRunner;
import com.oracle.bedrock.runtime.java.features.JmxFeature;
import com.oracle.bedrock.runtime.java.options.BedrockRunner;
import com.oracle.bedrock.runtime.java.options.ClassName;
import com.oracle.bedrock.runtime.java.options.IPv4Preferred;
import com.oracle.bedrock.runtime.java.options.JavaHome;
import com.oracle.bedrock.runtime.java.options.JavaModules;
import com.oracle.bedrock.runtime.java.options.JvmOption;
import com.oracle.bedrock.runtime.java.options.RemoteEvents;
import com.oracle.bedrock.runtime.java.options.SystemProperties;
import com.oracle.bedrock.runtime.java.options.WaitToStart;
import com.oracle.bedrock.runtime.java.profiles.CommercialFeatures;
import com.oracle.bedrock.runtime.java.profiles.RemoteDebugging;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.DisplayName;
import com.oracle.bedrock.runtime.options.EnvironmentVariables;
import com.oracle.bedrock.runtime.options.ErrorStreamRedirection;
import com.oracle.bedrock.runtime.options.Executable;
import com.oracle.bedrock.runtime.options.Orphanable;
import com.oracle.bedrock.runtime.options.WorkingDirectory;
import com.oracle.bedrock.table.Cell;
import com.oracle.bedrock.table.Row;
import com.oracle.bedrock.table.Table;
import com.oracle.bedrock.table.Tabularize;
import com.oracle.bedrock.util.ReflectionHelper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

@Internal
public class LocalJavaApplicationLauncher<A extends JavaApplication>
implements JavaApplicationLauncher<A> {
    private static Logger LOGGER = Logger.getLogger(LocalJavaApplicationLauncher.class.getName());

    /*
     * WARNING - void declaration
     */
    @Override
    public A launch(Platform platform, MetaClass<A> metaClass, OptionsByType optionsByType) {
        WaitToStart waitToStart;
        JavaApplication application;
        Process process;
        void var28_36;
        InetAddress parentAddress;
        String javaExecutable;
        JavaHome javaHome;
        Table diagnosticsTable = new Table(new Row[0]);
        diagnosticsTable.getOptions().add((Option)Table.orderByColumn((int)0));
        if (platform != null) {
            diagnosticsTable.addRow(new String[]{"Target Platform", platform.getName()});
        }
        OptionsByType launchOptions = OptionsByType.of((Option[])platform.getOptions().asArray());
        metaClass.onLaunching(platform, launchOptions);
        launchOptions.addAll(optionsByType);
        launchOptions.add((Option)Variable.with((String)"bedrock.runtime.id", (Object)UUID.randomUUID()));
        launchOptions.get(RemoteDebugging.class, new Object[0]);
        launchOptions.get(CommercialFeatures.class, new Object[0]);
        launchOptions.addAll(Profiles.getProfiles());
        for (Profile profile : launchOptions.getInstancesOf(Profile.class)) {
            profile.onLaunching(platform, metaClass, launchOptions);
        }
        metaClass.onLaunch(platform, launchOptions);
        DisplayName displayName = this.getDisplayName(launchOptions);
        Executable executable = (Executable)launchOptions.getOrSetDefault(Executable.class, (Option)Executable.named("java"));
        ProcessBuilder processBuilder = new ProcessBuilder(executable.getName());
        WorkingDirectory workingDirectory = (WorkingDirectory)launchOptions.getOrSetDefault(WorkingDirectory.class, (Option)WorkingDirectory.currentDirectory());
        File directory = workingDirectory.resolve(platform, launchOptions);
        launchOptions.add((Option)WorkingDirectory.at(directory));
        if (directory != null) {
            processBuilder.directory(directory);
            diagnosticsTable.addRow(new String[]{"Working Directory", directory.toString()});
        }
        EnvironmentVariables environmentVariables = (EnvironmentVariables)launchOptions.get(EnvironmentVariables.class, new Object[0]);
        switch (environmentVariables.getSource()) {
            case Custom: {
                processBuilder.environment().clear();
                diagnosticsTable.addRow(new String[]{"Environment Variables", "(cleared)"});
                break;
            }
            case ThisApplication: {
                Map<String, String> map = System.getenv();
                processBuilder.environment().clear();
                processBuilder.environment().putAll(map);
                diagnosticsTable.addRow(new String[]{"Environment Variables", "(based on parent process)"});
                break;
            }
            case TargetPlatform: {
                diagnosticsTable.addRow(new String[]{"Environment Variables", "(based on platform defaults)"});
            }
        }
        Properties variables = environmentVariables.realize(platform, launchOptions.asArray());
        for (String variableName : variables.stringPropertyNames()) {
            processBuilder.environment().put(variableName, variables.getProperty(variableName));
        }
        if (variables.size() > 0) {
            Table table = Tabularize.tabularize((Properties)variables);
            diagnosticsTable.addRow(new String[]{"", table.toString()});
        }
        if ((javaHome = (JavaHome)launchOptions.get(JavaHome.class, new Object[0])) == null) {
            javaHome = JavaHome.at(System.getProperty("java.home", null));
        }
        if (javaHome != null) {
            processBuilder.environment().put("JAVA_HOME", StringHelper.doubleQuoteIfNecessary((String)javaHome.get()));
        }
        if (javaHome == null) {
            javaExecutable = StringHelper.doubleQuoteIfNecessary((String)executable.getName());
        } else {
            String javaHomePath = javaHome.get();
            javaHomePath = javaHomePath.trim();
            diagnosticsTable.addRow(new String[]{"Java Home", javaHomePath});
            if (!javaHomePath.endsWith(File.separator)) {
                javaHomePath = javaHomePath + File.separator;
            }
            javaExecutable = StringHelper.doubleQuoteIfNecessary((String)(javaHomePath + "bin" + File.separator + executable.getName()));
        }
        processBuilder.command(javaExecutable);
        diagnosticsTable.addRow(new String[]{"Java Executable", javaExecutable});
        JavaModules modular = (JavaModules)launchOptions.get(JavaModules.class, new Object[0]);
        boolean useModules = modular.isEnabled();
        ClassPath classPath = (ClassPath)launchOptions.get(ClassPath.class, new Object[0]);
        try {
            classPath = new ClassPath(classPath, ClassPath.ofClass(platform.getClass()));
            for (Option option : launchOptions.getInstancesOf(Option.class)) {
                classPath = new ClassPath(classPath, ClassPath.ofClass(option.getClass()));
            }
            BedrockRunner bedrockRunner = (BedrockRunner)optionsByType.get(BedrockRunner.class, new Object[0]);
            if (bedrockRunner != null && bedrockRunner.isEnabled()) {
                classPath = new ClassPath(classPath, ClassPath.ofClass(bedrockRunner.getClassOfRunner()));
            }
            launchOptions.add((Option)classPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to locate required classes for the class path", e);
        }
        processBuilder.command().add(useModules ? "--module-path" : "-cp");
        processBuilder.command().add(classPath.toString(launchOptions.asArray()));
        if (useModules) {
            Table modulePathTable = classPath.getTable();
            modulePathTable.getOptions().add((Option)Cell.Separator.of((String)""));
            diagnosticsTable.addRow(new String[]{"Module Path", modulePathTable.toString()});
            ClassPath path = modular.getClassPath();
            if (path != null && !path.isEmpty()) {
                processBuilder.command().add("-cp");
                processBuilder.command().add(path.toString(launchOptions.asArray()));
                Table classPathTable = path.getTable();
                classPathTable.getOptions().add((Option)Cell.Separator.of((String)""));
                diagnosticsTable.addRow(new String[]{"Class Path", classPathTable.toString()});
            }
        } else {
            Table classPathTable = classPath.getTable();
            classPathTable.getOptions().add((Option)Cell.Separator.of((String)""));
            diagnosticsTable.addRow(new String[]{"Class Path", classPathTable.toString()});
        }
        String applicationName = displayName.resolve(launchOptions);
        final SocketBasedRemoteChannelServer server = new SocketBasedRemoteChannelServer(applicationName);
        RemoteEvents remoteEvents = (RemoteEvents)launchOptions.get(RemoteEvents.class, new Object[0]);
        remoteEvents.forEach((remoteEventListener, listenerOptions) -> server.addListener((RemoteEventListener)remoteEventListener, (Option)listenerOptions));
        try {
            server.open();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create remote execution server for the application", e);
        }
        IPv4Preferred iPv4Preferred = (IPv4Preferred)launchOptions.get(IPv4Preferred.class, new Object[0]);
        if (iPv4Preferred.isPreferred()) {
            try {
                parentAddress = InetAddress.getByName("127.0.0.1");
            }
            catch (UnknownHostException e) {
                parentAddress = InetAddress.getLoopbackAddress();
            }
        } else {
            parentAddress = InetAddress.getLoopbackAddress();
        }
        Table systemPropertiesTable = new Table(new Row[0]);
        systemPropertiesTable.getOptions().add((Option)Table.orderByColumn((int)0));
        systemPropertiesTable.getOptions().add((Option)Cell.Separator.of((String)""));
        String parentURI = "//" + parentAddress.getHostAddress() + ":" + server.getPort();
        systemPropertiesTable.addRow(new String[]{"bedrock.runtime.parent", parentURI.toString()});
        processBuilder.command().add("-Dbedrock.runtime.parent=" + parentURI);
        Orphanable orphanable = (Orphanable)launchOptions.get(Orphanable.class, new Object[0]);
        processBuilder.command().add("-Dbedrock.runtime.orphanable=" + orphanable.isOrphanable());
        systemPropertiesTable.addRow(new String[]{"bedrock.runtime.orphanable", Boolean.toString(orphanable.isOrphanable())});
        Properties systemProperties = ((SystemProperties)launchOptions.get(SystemProperties.class, new Object[0])).resolve(platform, launchOptions);
        for (String string : systemProperties.stringPropertyNames()) {
            String propertyValue = systemProperties.getProperty(string);
            if (!string.startsWith("bedrock.profile.") && string.startsWith("bedrock")) continue;
            processBuilder.command().add("-D" + string + (propertyValue.isEmpty() ? "" : "=" + propertyValue));
            systemPropertiesTable.addRow(new String[]{string, propertyValue});
        }
        diagnosticsTable.addRow(new String[]{"System Properties", systemPropertiesTable.toString()});
        StringBuilder jvmOptions = new StringBuilder();
        for (JvmOption jvmOption : launchOptions.getInstancesOf(JvmOption.class)) {
            for (String value : jvmOption.resolve(launchOptions)) {
                processBuilder.command().add(value);
                if (jvmOptions.length() > 0) {
                    jvmOptions.append(" ");
                }
                jvmOptions.append(value);
            }
        }
        if (jvmOptions.length() > 0) {
            diagnosticsTable.addRow(new String[]{"Java Options", jvmOptions.toString()});
        }
        for (String propertyName : System.getProperties().stringPropertyNames()) {
            if (!propertyName.startsWith("bedrock.runtime.inherit.")) continue;
            String propertyValue = System.getProperty(propertyName);
            ExpressionEvaluator evaluator = new ExpressionEvaluator((Variables)launchOptions.get(Variables.class, new Object[0]));
            propertyValue = (String)evaluator.evaluate(propertyValue, String.class);
            processBuilder.command().add(propertyValue);
        }
        String string = JavaApplicationRunner.class.getName();
        if (useModules) {
            String string2 = "com.oracle.bedrock.runtime/" + string;
            processBuilder.command().add("-m");
        }
        processBuilder.command().add((String)var28_36);
        ClassName className = (ClassName)launchOptions.get(ClassName.class, new Object[0]);
        if (className == null) {
            throw new IllegalArgumentException("Java Application ClassName not specified");
        }
        String applicationClassName = className.getName();
        processBuilder.command().add(applicationClassName);
        diagnosticsTable.addRow(new String[]{"Application Launcher", var28_36});
        diagnosticsTable.addRow(new String[]{"Application Class", applicationClassName});
        diagnosticsTable.addRow(new String[]{"Application", applicationName});
        List<String> argList = ((Arguments)launchOptions.get(Arguments.class, new Object[0])).resolve(platform, launchOptions);
        launchOptions.add((Option)Arguments.of(argList));
        String arguments = "";
        for (String argument : argList) {
            processBuilder.command().add(argument);
            arguments = arguments + argument + " ";
        }
        if (arguments.length() > 0) {
            diagnosticsTable.addRow(new String[]{"Application Arguments", arguments});
        }
        ErrorStreamRedirection redirection = (ErrorStreamRedirection)launchOptions.get(ErrorStreamRedirection.class, new Object[0]);
        processBuilder.redirectErrorStream(redirection.isEnabled());
        diagnosticsTable.addRow(new String[]{"Standard Error Device", redirection.isEnabled() ? "stdout" : "stderr"});
        diagnosticsTable.addRow(new String[]{"Application Launch Time", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())});
        boolean launchLogging = ((LaunchLogging)optionsByType.get(LaunchLogging.class, new Object[0])).isEnabled();
        if (launchLogging && LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Oracle Bedrock " + Bedrock.getVersion() + ": Starting Application...\n------------------------------------------------------------------------\n" + diagnosticsTable.toString() + "\n------------------------------------------------------------------------\n");
        }
        try {
            process = processBuilder.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to build the underlying native process for the application", e);
        }
        LocalJavaApplicationProcess localJavaProcess = new LocalJavaApplicationProcess(process, server, systemProperties);
        Class<JavaApplication> applicationClass = metaClass.getImplementationClass(platform, launchOptions);
        try {
            Constructor constructor = ReflectionHelper.getCompatibleConstructor(applicationClass, (Class[])new Class[]{platform.getClass(), localJavaProcess.getClass(), launchOptions.getClass()});
            application = (JavaApplication)constructor.newInstance(platform, localJavaProcess, launchOptions);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate the Application class specified by the MetaClass:" + metaClass, e);
        }
        if (JmxFeature.isSupportedBy(application)) {
            application.add((Object)new JmxFeature());
        }
        if ((waitToStart = (WaitToStart)launchOptions.get(WaitToStart.class, new Object[0])).isEnabled()) {
            Timeout timeout = (Timeout)launchOptions.get(Timeout.class, new Object[0]);
            DeferredHelper.ensure((Deferred)new AbstractDeferred<Boolean>(){

                public Boolean get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
                    if (!server.getRemoteChannels().iterator().hasNext()) {
                        throw new TemporarilyUnavailableException((Deferred)this);
                    }
                    return true;
                }
            }, (Option[])new Option[]{DeferredHelper.within((Timeout)timeout)});
        }
        metaClass.onLaunched(platform, application, launchOptions);
        for (Profile profile : launchOptions.getInstancesOf(Profile.class)) {
            profile.onLaunched(platform, application, launchOptions);
        }
        for (ApplicationListener listener : launchOptions.getInstancesOf(ApplicationListener.class)) {
            listener.onLaunched(application);
        }
        return (A)application;
    }

    public static class LocalJavaApplicationProcess
    extends LocalApplicationProcess
    implements JavaApplicationProcess {
        private ControllableRemoteChannel remoteExecutor;
        private Properties systemProperties;

        public LocalJavaApplicationProcess(Process process, ControllableRemoteChannel remoteExecutor, Properties systemProperties) {
            super(process);
            this.remoteExecutor = remoteExecutor;
            this.systemProperties = systemProperties;
        }

        @Override
        public Properties getSystemProperties() {
            return this.systemProperties;
        }

        @Override
        public <T> CompletableFuture<T> submit(RemoteCallable<T> callable, Option ... options) throws IllegalStateException {
            return this.remoteExecutor.submit(callable, options);
        }

        @Override
        public CompletableFuture<Void> submit(RemoteRunnable runnable, Option ... options) throws IllegalStateException {
            return this.remoteExecutor.submit(runnable, options);
        }

        @Override
        public void addListener(RemoteEventListener listener, Option ... options) {
            this.remoteExecutor.addListener(listener, options);
        }

        @Override
        public void removeListener(RemoteEventListener listener, Option ... options) {
            this.remoteExecutor.removeListener(listener, options);
        }

        @Override
        public CompletableFuture<Void> raise(RemoteEvent event, Option ... options) {
            return this.remoteExecutor.raise(event, options);
        }

        @Override
        public void close() {
            super.close();
            this.remoteExecutor.close();
        }
    }
}

