/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.options;

import com.oracle.bedrock.ComposableOption;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.runtime.java.options.JvmOption;
import java.util.ArrayList;

public class HeapSize
implements ComposableOption<HeapSize>,
JvmOption {
    private int initial;
    private Units initialUnits;
    private int maximum;
    private Units maximumUnits;

    private HeapSize() {
        this.initial = -1;
        this.initialUnits = Units.KB;
        this.maximum = -1;
        this.maximumUnits = Units.KB;
    }

    private HeapSize(HeapSize heapSize) {
        this.initial = heapSize.initial;
        this.initialUnits = heapSize.initialUnits;
        this.maximum = heapSize.maximum;
        this.maximumUnits = heapSize.maximumUnits;
    }

    @OptionsByType.Default
    public static HeapSize useDefaults() {
        return new HeapSize();
    }

    public static HeapSize initial(int amount, Units units) {
        HeapSize heapSize = new HeapSize();
        heapSize.initial = amount;
        heapSize.initialUnits = units;
        return heapSize;
    }

    public static HeapSize maximum(int amount, Units units) {
        HeapSize heapSize = new HeapSize();
        heapSize.maximum = amount;
        heapSize.maximumUnits = units;
        return heapSize;
    }

    public static HeapSize of(int initial, Units initialUnits, int maximum, Units maximumUnits) {
        HeapSize heapSize = new HeapSize();
        heapSize.initial = initial;
        heapSize.initialUnits = initialUnits;
        heapSize.maximum = maximum;
        heapSize.maximumUnits = maximumUnits;
        return heapSize;
    }

    public long getInitialSizeAs(Units units) {
        return (long)this.initial * this.initialUnits.getBytes() / units.getBytes();
    }

    public long getMaximumSizeAs(Units units) {
        return (long)this.maximum * this.maximumUnits.getBytes() / units.getBytes();
    }

    @Override
    public Iterable<String> resolve(OptionsByType optionsByType) {
        ArrayList<String> values = new ArrayList<String>(2);
        if (this.initial >= 0) {
            values.add("-Xms" + this.initial + this.initialUnits.toString().charAt(0));
        }
        if (this.maximum >= 0) {
            values.add("-Xmx" + this.maximum + this.maximumUnits.toString().charAt(0));
        }
        return values;
    }

    public HeapSize compose(HeapSize other) {
        long otherMaximum;
        long otherInitial;
        HeapSize result = new HeapSize();
        long initial = this.initial <= 0 ? 0L : this.getInitialSizeAs(Units.KB);
        long l = otherInitial = other.initial <= 0 ? 0L : other.getInitialSizeAs(Units.KB);
        if (initial > otherInitial) {
            result.initial = this.initial;
            result.initialUnits = this.initialUnits;
        } else {
            result.initial = other.initial;
            result.initialUnits = other.initialUnits;
        }
        long maximum = this.maximum <= 0 ? 0L : this.getMaximumSizeAs(Units.KB);
        long l2 = otherMaximum = other.maximum <= 0 ? 0L : other.getMaximumSizeAs(Units.KB);
        if (maximum > otherMaximum) {
            result.maximum = this.maximum;
            result.maximumUnits = this.maximumUnits;
        } else {
            result.maximum = other.maximum;
            result.maximumUnits = other.maximumUnits;
        }
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HeapSize)) {
            return false;
        }
        HeapSize other = (HeapSize)object;
        if (this.getInitialSizeAs(Units.KB) != other.getInitialSizeAs(Units.KB)) {
            return false;
        }
        return this.getMaximumSizeAs(Units.KB) == other.getMaximumSizeAs(Units.KB);
    }

    public int hashCode() {
        int result = this.initial;
        result = 31 * result + this.maximum;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String value : this.resolve(OptionsByType.empty())) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(value);
        }
        return builder.toString();
    }

    public static enum Units {
        KB((long)Math.pow(1024.0, 1.0)),
        MB((long)Math.pow(1024.0, 2.0)),
        GB((long)Math.pow(1024.0, 3.0));

        private long bytes;

        private Units(long bytes) {
            this.bytes = bytes;
        }

        long getBytes() {
            return this.bytes;
        }
    }
}

